/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.inventory;

import growthcraft.api.core.nbt.INBTSerializableContext;
import growthcraft.api.core.nbt.NBTHelper;
import growthcraft.api.core.nbt.NBTType;
import growthcraft.core.common.inventory.IInventoryWatcher;
import growthcraft.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GrcInternalInventory
implements IInventory,
INBTSerializableContext {
    public static final int WILDCARD_SLOT = -1;
    protected String inventoryName = "grc.inventory.internal.name";
    protected ItemStack[] items;
    protected int maxSize;
    protected int maxStackSize;
    protected Object parent;

    public GrcInternalInventory(Object par, int size, int maxStack) {
        this.parent = par;
        this.maxSize = size;
        this.maxStackSize = maxStack;
        this.items = new ItemStack[this.maxSize];
    }

    public GrcInternalInventory(Object par, int size) {
        this(par, size, 64);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    protected void onSlotChanged(int index) {
        if (this.parent instanceof IInventoryWatcher) {
            ((IInventoryWatcher)this.parent).onInventoryChanged(this, index);
        } else if (this.parent instanceof IInventory) {
            ((IInventory)this.parent).func_70296_d();
        }
    }

    public void func_70296_d() {
        this.onSlotChanged(-1);
    }

    public void clear() {
        for (int i = 0; i < this.getMaxSize(); ++i) {
            this.items[i] = null;
        }
        this.onSlotChanged(-1);
    }

    @Deprecated
    public void clearInventory() {
        this.clear();
    }

    protected void readFromNBT(NBTTagList data) {
        this.items = ItemUtils.clearInventorySlots(this.items, this.func_70302_i_());
        NBTHelper.readInventorySlotsFromNBT(this.items, data);
        this.onSlotChanged(-1);
    }

    @Override
    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagList list = data.func_150295_c(name, NBTType.COMPOUND.id);
        if (list != null) {
            this.readFromNBT(list);
        }
    }

    protected void writeToNBT(NBTTagList data) {
        NBTHelper.writeInventorySlotsToNBT(this.items, data);
    }

    @Override
    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagList invData = new NBTTagList();
        this.writeToNBT(invData);
        data.func_74782_a(name, (NBTBase)invData);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer _player) {
        return true;
    }

    public int func_70302_i_() {
        return this.maxSize;
    }

    public int func_70297_j_() {
        return this.maxStackSize;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public GrcInternalInventory setInventoryName(String name) {
        this.inventoryName = name;
        return this;
    }

    public String func_145825_b() {
        return this.inventoryName;
    }

    public ItemStack func_70301_a(int index) {
        return this.items[index];
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack oldStack = this.items[index];
        this.items[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            int discarded = stack.field_77994_a - this.func_70297_j_();
            this.items[index].field_77994_a = this.func_70297_j_();
            if (discarded > 0 && this.parent instanceof IInventoryWatcher) {
                ((IInventoryWatcher)this.parent).onItemDiscarded(this, stack, index, discarded);
            }
        }
        if (oldStack != stack) {
            this.onSlotChanged(index);
        }
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.items[index];
        this.items[index] = null;
        if (stack != null) {
            this.onSlotChanged(index);
        }
        return stack;
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (this.items[index] != null) {
            ItemStack itemstack;
            if (this.items[index].field_77994_a <= amount) {
                itemstack = this.items[index];
                this.items[index] = null;
            } else {
                itemstack = this.items[index].func_77979_a(amount);
                if (this.items[index].field_77994_a <= 0) {
                    this.items[index] = null;
                }
            }
            this.onSlotChanged(index);
            return itemstack;
        }
        return null;
    }
}

