/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.block;

import growthcraft.api.core.nbt.INBTItemSerializable;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.Utils;
import growthcraft.core.common.block.GrcBlockBase;
import growthcraft.core.common.block.IDroppableBlock;
import growthcraft.core.common.block.IRotatableBlock;
import growthcraft.core.common.block.IWrenchable;
import growthcraft.core.common.inventory.InventoryProcessor;
import growthcraft.core.common.item.IItemTileBlock;
import growthcraft.core.common.tileentity.feature.ICustomDisplayName;
import growthcraft.core.common.tileentity.feature.IItemHandler;
import growthcraft.core.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class GrcBlockContainer
extends GrcBlockBase
implements IDroppableBlock,
IRotatableBlock,
IWrenchable,
ITileEntityProvider {
    protected Random rand = new Random();
    protected Class<? extends TileEntity> tileEntityType;

    public GrcBlockContainer(@Nonnull Material material) {
        super(material);
        this.field_149758_A = true;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int code, int value) {
        super.func_149696_a(world, x, y, z, code, value);
        Object te = this.getTileEntity((IBlockAccess)world, x, y, z);
        return te != null ? te.func_145842_c(code, value) : false;
    }

    protected void setTileEntityType(Class<? extends TileEntity> klass) {
        this.tileEntityType = klass;
    }

    @Override
    public boolean isRotatable(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public void doRotateBlock(World world, int x, int y, int z, ForgeDirection side) {
        ForgeDirection current;
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection newDirection = current = ForgeDirection.getOrientation((int)meta);
        if (current == side) {
            switch (current) {
                case UP: {
                    newDirection = ForgeDirection.NORTH;
                    break;
                }
                case DOWN: {
                    newDirection = ForgeDirection.SOUTH;
                    break;
                }
                case NORTH: 
                case EAST: {
                    newDirection = ForgeDirection.UP;
                    break;
                }
                case SOUTH: 
                case WEST: {
                    newDirection = ForgeDirection.DOWN;
                    break;
                }
            }
        } else {
            switch (current) {
                case UP: {
                    newDirection = ForgeDirection.DOWN;
                    break;
                }
                case DOWN: {
                    newDirection = ForgeDirection.UP;
                    break;
                }
                case WEST: {
                    newDirection = ForgeDirection.SOUTH;
                    break;
                }
                case EAST: {
                    newDirection = ForgeDirection.NORTH;
                    break;
                }
                case NORTH: {
                    newDirection = ForgeDirection.WEST;
                    break;
                }
                case SOUTH: {
                    newDirection = ForgeDirection.EAST;
                    break;
                }
            }
        }
        if (newDirection != current) {
            world.func_72921_c(x, y, z, newDirection.ordinal(), 3);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection side) {
        if (this.isRotatable((IBlockAccess)world, x, y, z, side)) {
            this.doRotateBlock(world, x, y, z, side);
            world.func_147471_g(x, y, z);
            return true;
        }
        return false;
    }

    protected void fellBlockFromWrench(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.shouldDropTileStack(world, x, y, z, metadata, 0)) {
            GrowthCraftCore.getLogger().info("Dropping Tile As ItemStack", new Object[0]);
            this.getTileItemStackDrops(drops, world, x, y, z, metadata, 0);
            for (ItemStack stack : drops) {
                ItemUtils.spawnItemStack(world, x, y, z, stack, world.field_73012_v);
            }
            Object te = this.getTileEntity((IBlockAccess)world, x, y, z);
            if (te instanceof IInventory) {
                GrowthCraftCore.getLogger().info("Clearing Inventory", new Object[0]);
                InventoryProcessor.instance().clearSlots((IInventory)te);
            }
            GrowthCraftCore.getLogger().info("Setting Block To Air", new Object[0]);
            world.func_147468_f(x, y, z);
        } else {
            this.fellBlockAsItem(world, x, y, z);
        }
    }

    @Override
    public boolean wrenchBlock(World world, int x, int y, int z, EntityPlayer player, ItemStack wrench) {
        if (player == null) {
            return false;
        }
        if (!ItemUtils.canWrench(wrench, player, x, y, z)) {
            return false;
        }
        if (!player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            this.fellBlockFromWrench(world, x, y, z);
            ItemUtils.wrenchUsed(wrench, player, x, y, z);
        }
        return true;
    }

    public boolean tryWrenchItem(EntityPlayer player, World world, int x, int y, int z) {
        if (player == null) {
            return false;
        }
        ItemStack is = player.field_71071_by.func_70448_g();
        return this.wrenchBlock(world, x, y, z, player, is);
    }

    protected void placeBlockByEntityDirection(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (this.isRotatable((IBlockAccess)world, x, y, z, ForgeDirection.UNKNOWN)) {
            int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int meta = 2;
            if (l == 0) {
                meta = 1;
            } else if (l == 1) {
                meta = 2;
            } else if (l == 2) {
                meta = 0;
            } else if (l == 3) {
                meta = 3;
            }
            world.func_72921_c(x, y, z, meta, 2);
        }
    }

    protected void setupCustomDisplayName(World world, int x, int y, int z, ItemStack stack) {
        Object te;
        if (stack.func_82837_s() && (te = this.getTileEntity((IBlockAccess)world, x, y, z)) instanceof ICustomDisplayName) {
            ((ICustomDisplayName)te).setGuiDisplayName(stack.func_82833_r());
        }
    }

    protected NBTTagCompound getTileTagCompound(World world, int x, int y, int z, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IItemTileBlock) {
            IItemTileBlock itb = (IItemTileBlock)item;
            return itb.getTileTagCompound(stack);
        }
        GrowthCraftCore.getLogger().error("Cannot get tile tag compound for a non IItemTileBlock: stack=%s block=%s", stack, this);
        return null;
    }

    protected void setTileTagCompound(World world, int x, int y, int z, ItemStack stack, NBTTagCompound tag) {
        Item item = stack.func_77973_b();
        if (item instanceof IItemTileBlock) {
            IItemTileBlock itb = (IItemTileBlock)item;
            itb.setTileTagCompound(stack, tag);
        } else {
            GrowthCraftCore.getLogger().error("Cannot set tile tag compound for a non IItemTileBlock: stack=%s block=%s", stack, this);
        }
    }

    protected boolean shouldRestoreBlockState(World world, int x, int y, int z, ItemStack stack) {
        return false;
    }

    protected void restoreBlockStateFromStack(World world, int x, int y, int z, ItemStack stack) {
        if (this.shouldRestoreBlockState(world, x, y, z, stack)) {
            Object te = this.getTileEntity((IBlockAccess)world, x, y, z);
            if (te instanceof INBTItemSerializable) {
                NBTTagCompound tag = this.getTileTagCompound(world, x, y, z, stack);
                if (tag != null) {
                    ((INBTItemSerializable)te).readFromNBTForItem(tag);
                }
            } else {
                GrowthCraftCore.getLogger().error("Cannot restore tile from stack, the TileEntity does not support INBTItemSerializable: stack=%s block=%s tile=%s", stack, this, te);
            }
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        this.restoreBlockStateFromStack(world, x, y, z, stack);
        this.setupCustomDisplayName(world, x, y, z, stack);
    }

    protected void scatterInventory(World world, int x, int y, int z, Block block) {
        IInventory inventory;
        Object te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te instanceof IInventory && (inventory = (IInventory)te) != null) {
            for (int index = 0; index < inventory.func_70302_i_(); ++index) {
                ItemStack stack = inventory.func_70301_a(index);
                if (stack != null) {
                    ItemUtils.spawnItemStack(world, x, y, z, stack, this.rand);
                }
                inventory.func_70299_a(index, (ItemStack)null);
            }
            world.func_147453_f(x, y, z, block);
        }
    }

    protected boolean shouldScatterInventoryOnBreak(World world, int x, int y, int z) {
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (this.shouldScatterInventoryOnBreak(world, x, y, z)) {
            this.scatterInventory(world, x, y, z, block);
        }
        world.func_147475_p(x, y, z);
    }

    protected ItemStack createHarvestedBlockItemStack(World world, EntityPlayer player, int x, int y, int z, int meta) {
        return this.func_149644_j(meta);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        player.func_71064_a(StatList.field_75934_C[GrcBlockContainer.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(world, player, x, y, z, meta) && EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.createHarvestedBlockItemStack(world, player, x, y, z, meta);
            if (itemstack != null) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)world, (Block)this, (int)x, (int)y, (int)z, (int)meta, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack is : items) {
                this.func_149642_a(world, x, y, z, is);
            }
        } else {
            this.harvesters.set(player);
            int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            this.func_149697_b(world, x, y, z, meta, fortune);
            this.harvesters.set(null);
        }
    }

    protected boolean shouldDropTileStack(World world, int x, int y, int z, int metadata, int fortune) {
        return false;
    }

    private void getDefaultDrops(List<ItemStack> ret, World world, int x, int y, int z, int metadata, int fortune) {
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_149692_a(metadata)));
        }
    }

    protected void getTileItemStackDrops(List<ItemStack> ret, World world, int x, int y, int z, int metadata, int fortune) {
        Object te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te instanceof INBTItemSerializable) {
            NBTTagCompound tag = new NBTTagCompound();
            ((INBTItemSerializable)te).writeToNBTForItem(tag);
            ItemStack stack = new ItemStack((Block)this, 1, metadata);
            this.setTileTagCompound(world, x, y, z, stack, tag);
            ret.add(stack);
        } else {
            this.getDefaultDrops(ret, world, x, y, z, metadata, fortune);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.shouldDropTileStack(world, x, y, z, metadata, fortune)) {
            this.getTileItemStackDrops(ret, world, x, y, z, metadata, fortune);
        } else {
            this.getDefaultDrops(ret, world, x, y, z, metadata, fortune);
        }
        return ret;
    }

    protected boolean playerFillTank(World world, int x, int y, int z, IFluidHandler fh, ItemStack is, EntityPlayer player) {
        return Utils.playerFillTank(world, x, y, z, fh, is, player);
    }

    protected boolean playerDrainTank(World world, int x, int y, int z, IFluidHandler fh, ItemStack is, EntityPlayer player) {
        FluidStack fs = Utils.playerDrainTank(world, x, y, z, fh, is, player);
        return fs != null && fs.amount > 0;
    }

    private boolean handleIFluidHandler(World world, int x, int y, int z, EntityPlayer player, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IFluidHandler) {
            if (world.field_72995_K) {
                return true;
            }
            IFluidHandler fh = (IFluidHandler)te;
            ItemStack is = player.field_71071_by.func_70448_g();
            boolean needUpdate = false;
            if (!player.func_70093_af()) {
                if (this.playerDrainTank(world, x, y, z, fh, is, player) || this.playerFillTank(world, x, y, z, fh, is, player)) {
                    needUpdate = true;
                }
            } else if (this.playerFillTank(world, x, y, z, fh, is, player) || this.playerDrainTank(world, x, y, z, fh, is, player)) {
                needUpdate = true;
            }
            if (needUpdate) {
                world.func_147471_g(x, y, z);
                return true;
            }
        }
        return false;
    }

    protected boolean handleOnUseItem(IItemHandler.Action action, World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IItemHandler) {
            if (world.field_72995_K) {
                return true;
            }
            IItemHandler ih = (IItemHandler)te;
            ItemStack is = player.field_71071_by.func_70448_g();
            boolean needUpdate = false;
            if (ih.tryPlaceItem(action, player, is)) {
                needUpdate = true;
            } else if (ih.tryTakeItem(action, player, is)) {
                needUpdate = true;
            }
            if (needUpdate) {
                world.func_147471_g(x, y, z);
                return true;
            }
        }
        return false;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof IItemHandler && this.handleOnUseItem(IItemHandler.Action.LEFT, world, x, y, z, player)) {
            return;
        }
        super.func_149699_a(world, x, y, z, player);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float par7, float par8, float par9) {
        if (this.tryWrenchItem(player, world, x, y, z)) {
            return true;
        }
        if (this.handleIFluidHandler(world, x, y, z, player, meta)) {
            return true;
        }
        return this.handleOnUseItem(IItemHandler.Action.RIGHT, world, x, y, z, player);
    }

    public <T extends TileEntity> T getTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && this.tileEntityType.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int unused) {
        if (this.tileEntityType != null) {
            try {
                return this.tileEntityType.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Failed to create a new instance of an illegal class " + this.tileEntityType, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to create a new instance of " + this.tileEntityType + ", because lack of permissions", e);
            }
        }
        return null;
    }
}

