/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.core.client.ClientProxy;
import growthcraft.core.client.renderer.RenderPaddy;
import growthcraft.core.common.block.GrcBlockBase;
import growthcraft.core.common.block.IPaddy;
import growthcraft.core.common.block.IPaddyCrop;
import growthcraft.core.util.ItemUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class BlockPaddyBase
extends GrcBlockBase
implements IPaddy {
    public BlockPaddyBase(Material material) {
        super(material);
        this.func_149675_a(true);
    }

    @Override
    public boolean isFilledWithFluid(IBlockAccess world, int x, int y, int z, int meta) {
        return meta >= this.getMaxPaddyMeta(world, x, y, z);
    }

    public void drainPaddy(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 0) {
            world.func_72921_c(x, y, z, meta - 1, 3);
        }
    }

    public void fillPaddy(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, this.getMaxPaddyMeta((IBlockAccess)world, x, y, z), 3);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (this.isBelowFillingFluid((IBlockAccess)world, x, y, z) && world.func_72951_B(x, y + 1, z)) {
            this.fillPaddy(world, x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float par7, float par8, float par9) {
        FluidStack addF;
        if (world.field_72995_K) {
            return true;
        }
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && FluidContainerRegistry.isFilledContainer((ItemStack)itemstack) && (addF = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack)) != null) {
            int radius = addF.amount * 2 / 1000;
            if (radius % 2 == 0) {
                --radius;
            }
            if (addF.getFluid() == this.getFillingFluid() && radius > 0) {
                for (int lx = x - radius; lx <= x + radius; ++lx) {
                    for (int lz = z - radius; lz <= z + radius; ++lz) {
                        if (world.func_147439_a(lx, y, lz) != this) continue;
                        this.fillPaddy(world, lx, y, lz);
                    }
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeStack(itemstack));
                }
                return true;
            }
        }
        return false;
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float par6) {
        if (!world.field_72995_K && world.field_73012_v.nextFloat() < par6 - 0.5f) {
            if (!(entity instanceof EntityPlayer) && !world.func_82736_K().func_82766_b("mobGriefing")) {
                return;
            }
            Block plant = world.func_147439_a(x, y + 1, z);
            if (plant instanceof IPaddyCrop) {
                plant.func_149697_b(world, x, y + 1, z, world.func_72805_g(x, y + 1, z), 0);
                world.func_147468_f(x, y + 1, z);
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        super.func_149695_a(world, x, y, z, par5);
        if (this.isBelowFillingFluid((IBlockAccess)world, x, y, z)) {
            this.fillPaddy(world, x, y, z);
        }
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        return ForgeDirection.UP != side;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public int func_149645_b() {
        return RenderPaddy.id;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInPass(int pass) {
        ClientProxy.paddyRenderPass = pass;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149743_a(World world, int i, int j, int k, AxisAlignedBB axis, List list, Entity entity) {
        int meta = world.func_72805_g(i, j, k);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.875f, 1.0f);
        super.func_149743_a(world, i, j, k, axis, list, entity);
        float thick = 0.125f;
        float j1 = 0.875f;
        float j2 = 1.0f;
        float i1 = 0.0f;
        float i2 = 1.0f;
        float k1 = 0.0f;
        float k2 = 1.0f;
        boolean boolXPos = this.canConnectPaddyTo((IBlockAccess)world, i + 1, j, k, meta);
        boolean boolXNeg = this.canConnectPaddyTo((IBlockAccess)world, i - 1, j, k, meta);
        boolean boolYPos = this.canConnectPaddyTo((IBlockAccess)world, i, j, k + 1, meta);
        boolean boolYNeg = this.canConnectPaddyTo((IBlockAccess)world, i, j, k - 1, meta);
        if (!boolXPos) {
            i1 = 0.875f;
            i2 = 1.0f;
            k1 = 0.125f;
            k2 = 0.875f;
            this.func_149676_a(i1, 0.875f, k1, i2, 1.0f, k2);
            super.func_149743_a(world, i, j, k, axis, list, entity);
        }
        if (!boolXNeg) {
            i1 = 0.0f;
            i2 = 0.125f;
            k1 = 0.125f;
            k2 = 0.875f;
            this.func_149676_a(i1, 0.875f, k1, i2, 1.0f, k2);
            super.func_149743_a(world, i, j, k, axis, list, entity);
        }
        if (!boolYPos) {
            i1 = 0.125f;
            i2 = 0.875f;
            k1 = 0.875f;
            k2 = 1.0f;
            this.func_149676_a(i1, 0.875f, k1, i2, 1.0f, k2);
            super.func_149743_a(world, i, j, k, axis, list, entity);
        }
        if (!boolYNeg) {
            i1 = 0.125f;
            i2 = 0.875f;
            k1 = 0.0f;
            k2 = 0.125f;
            this.func_149676_a(i1, 0.875f, k1, i2, 1.0f, k2);
            super.func_149743_a(world, i, j, k, axis, list, entity);
        }
        if (!(this.canConnectPaddyTo((IBlockAccess)world, i - 1, j, k - 1, meta) && boolXNeg && boolYNeg)) {
            this.func_149676_a(0.0f, 0.875f, 0.0f, 0.125f, 1.0f, 0.125f);
            super.func_149743_a(world, i, j, k, axis, list, entity);
        }
        if (!(this.canConnectPaddyTo((IBlockAccess)world, i + 1, j, k - 1, meta) && boolXPos && boolYNeg)) {
            this.func_149676_a(0.875f, 0.875f, 0.0f, 1.0f, 1.0f, 0.125f);
            super.func_149743_a(world, i, j, k, axis, list, entity);
        }
        if (!(this.canConnectPaddyTo((IBlockAccess)world, i - 1, j, k + 1, meta) && boolXNeg && boolYPos)) {
            this.func_149676_a(0.0f, 0.875f, 0.875f, 0.125f, 1.0f, 1.0f);
            super.func_149743_a(world, i, j, k, axis, list, entity);
        }
        if (!(this.canConnectPaddyTo((IBlockAccess)world, i + 1, j, k + 1, meta) && boolXPos && boolYPos)) {
            this.func_149676_a(0.875f, 0.875f, 0.875f, 1.0f, 1.0f, 1.0f);
            super.func_149743_a(world, i, j, k, axis, list, entity);
        }
        this.func_149683_g();
    }

    @Override
    public boolean canConnectPaddyTo(IBlockAccess world, int i, int j, int k, int m) {
        int meta;
        if (m > 0) {
            m = 1;
        }
        if ((meta = world.func_72805_g(i, j, k)) > 0) {
            meta = 1;
        }
        return this == world.func_147439_a(i, j, k) && meta == m;
    }
}

