/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core;

import growthcraft.api.core.log.ILoggable;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.core.util.StringUtils;
import growthcraft.core.ConfigTypeHandler;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;

public abstract class ConfigBase
implements ILoggable {
    static final String DEFAULT_STR = "; Default : ";
    @ConfigOption(catergory="Debug", name="Enable Debugging", desc="Should Growthcraft log all its activity for debugging purposes?")
    public boolean debugEnabled;
    protected ILogger logger = NullLogger.INSTANCE;
    protected Configuration config;

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    private void loadConfigForClass(Class klass) {
        for (Field field : klass.getDeclaredFields()) {
            ConfigOption opt = field.getAnnotation(ConfigOption.class);
            if (opt == null) continue;
            Class<?> typeClass = field.getType();
            try {
                if (Byte.TYPE.equals(typeClass)) {
                    byte val = field.getByte(this);
                    field.setShort(this, (byte)this.config.get(opt.catergory(), opt.name(), (int)val, opt.desc() + DEFAULT_STR + val).getInt());
                } else if (Short.TYPE.equals(typeClass)) {
                    short val = field.getShort(this);
                    field.setShort(this, (short)this.config.get(opt.catergory(), opt.name(), (int)val, opt.desc() + DEFAULT_STR + val).getInt());
                } else if (Integer.TYPE.equals(typeClass)) {
                    int val = field.getInt(this);
                    field.setInt(this, this.config.get(opt.catergory(), opt.name(), val, opt.desc() + DEFAULT_STR + val).getInt());
                } else if (Float.TYPE.equals(typeClass)) {
                    float val = field.getFloat(this);
                    field.setFloat(this, (float)this.config.get(opt.catergory(), opt.name(), (double)val, opt.desc() + DEFAULT_STR + val).getDouble());
                } else if (Boolean.TYPE.equals(typeClass)) {
                    boolean val = field.getBoolean(this);
                    field.setBoolean(this, this.config.get(opt.catergory(), opt.name(), val, opt.desc() + DEFAULT_STR + val).getBoolean());
                } else if (Double.TYPE.equals(typeClass)) {
                    double val = field.getDouble(this);
                    field.setDouble(this, this.config.get(opt.catergory(), opt.name(), val, opt.desc() + DEFAULT_STR + val).getDouble());
                } else if (String.class.equals(typeClass)) {
                    String val = (String)field.get(this);
                    field.set(this, this.config.get(opt.catergory(), opt.name(), val, opt.desc() + DEFAULT_STR + val).getString());
                } else {
                    boolean found = false;
                    for (ConfigTypeHandler handler : ConfigTypeHandler.handlers) {
                        if (!handler.canHandle(field)) continue;
                        field.set(this, handler.handle(field, this.config));
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.logger.error("Unhandled config option: type=%s option=%s", typeClass, opt.name());
                    }
                }
                this.logger.debug("ConfigBase<%s>{catergory:'%s', name:'%s', key:'%s', value:%s}", this.toString(), opt.catergory(), opt.name(), field.getName(), StringUtils.inspect(field.get(this)));
            }
            catch (IllegalAccessException ex) {
                this.logger.error(ex.toString(), new Object[0]);
            }
        }
    }

    protected void autoloadConfig() {
        for (Class<?> currentClass = this.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            this.loadConfigForClass(currentClass);
        }
    }

    protected void loadConfig() {
        this.autoloadConfig();
    }

    protected void postLoadConfig() {
    }

    public void load(File configDir, String filename) {
        this.config = new Configuration(new File(configDir, filename));
        try {
            this.config.load();
            this.loadConfig();
            this.postLoadConfig();
        }
        catch (Throwable throwable) {
            if (this.config.hasChanged()) {
                this.config.save();
                this.logger.warn("Config file %s has changed, be sure for check for updates.", filename);
            }
            throw throwable;
        }
        if (this.config.hasChanged()) {
            this.config.save();
            this.logger.warn("Config file %s has changed, be sure for check for updates.", filename);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface ConfigOption {
        public String catergory() default "general";

        public String name();

        public String desc() default "";

        public String opt() default "";

        public String def() default "";
    }
}

