/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.util;

import growthcraft.api.cellar.common.Residue;
import growthcraft.api.cellar.util.CellarBoozeBuilder;
import growthcraft.api.cellar.util.ICellarBoozeBuilder;
import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.util.MultiStacksUtil;
import growthcraft.cellar.util.GrcCellarUserApis;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class UserApiCellarBoozeBuilder
extends CellarBoozeBuilder {
    private GrcCellarUserApis userApis;

    public UserApiCellarBoozeBuilder(@Nonnull GrcCellarUserApis apis, @Nonnull Fluid fluid) {
        super(fluid);
        this.userApis = apis;
    }

    @Override
    public ICellarBoozeBuilder brewsTo(@Nonnull FluidStack result, @Nonnull Object stack, int time, @Nullable Residue residue) {
        this.userApis.getUserBrewingRecipes().addDefault(stack, new FluidStack(this.fluid, result.amount), result, residue, time);
        return this;
    }

    @Override
    public ICellarBoozeBuilder brewsFrom(@Nonnull FluidStack src, @Nonnull Object stack, int time, @Nullable Residue residue) {
        this.userApis.getUserBrewingRecipes().addDefault(stack, src, new FluidStack(this.fluid, src.amount), residue, time);
        return this;
    }

    @Override
    public ICellarBoozeBuilder fermentsTo(@Nonnull FluidStack result, @Nonnull Object stack, int time) {
        this.userApis.getUserFermentingRecipes().addDefault(stack, new FluidStack(this.fluid, result.amount), result, time);
        return this;
    }

    @Override
    public ICellarBoozeBuilder fermentsFrom(@Nonnull Object srcFluid, @Nonnull Object stack, int time) {
        IMultiFluidStacks src = MultiStacksUtil.toMultiFluidStacks(srcFluid);
        this.userApis.getUserFermentingRecipes().addDefault(stack, src, new FluidStack(this.fluid, src.getAmount()), time);
        return this;
    }

    @Override
    public ICellarBoozeBuilder pressesFrom(@Nonnull Object stack, int time, int amount, @Nullable Residue residue) {
        this.userApis.getUserPressingRecipes().addDefault(stack, new FluidStack(this.fluid, amount), time, residue);
        return this;
    }

    @Override
    public ICellarBoozeBuilder culturesTo(int amount, @Nonnull ItemStack stack, float heat, int time) {
        this.userApis.getUserCultureRecipes().addDefault(new FluidStack(this.fluid, amount), stack, heat, time);
        return this;
    }
}

