/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.util;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.booze.BoozeEffect;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.description.Describer;
import growthcraft.core.util.UnitFormatter;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class BoozeUtils {
    private BoozeUtils() {
    }

    public static float alcoholToTipsy(float alcoholRate) {
        return alcoholRate * 4.0f;
    }

    public static boolean isFermentedBooze(Fluid booze) {
        return CoreRegistry.instance().fluidDictionary().hasFluidTags(booze, BoozeTag.FERMENTED);
    }

    public static void addEffects(Fluid booze, ItemStack stack, World world, EntityPlayer player) {
        if (booze == null) {
            return;
        }
        BoozeEffect effect = CellarRegistry.instance().booze().getEffect(booze);
        if (effect != null) {
            effect.apply(world, (Entity)player, world.field_73012_v, null);
        }
    }

    public static void addInformation(Fluid booze, ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (booze == null) {
            return;
        }
        String s = UnitFormatter.fluidModifier(booze);
        if (s != null) {
            list.add(s);
        }
        Describer.getDescription(list, booze);
    }

    public static void addEffectInformation(Fluid booze, ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (booze == null) {
            return;
        }
        BoozeEffect effect = CellarRegistry.instance().booze().getEffect(booze);
        if (effect != null) {
            effect.getDescription(list);
        }
    }

    public static void addBottleInformation(Fluid booze, ItemStack stack, EntityPlayer player, List list, boolean bool, boolean showDetailed) {
        if (booze == null) {
            return;
        }
        BoozeUtils.addInformation(booze, stack, player, list, bool);
        if (showDetailed) {
            BoozeUtils.addEffectInformation(booze, stack, player, list, bool);
        }
    }

    public static boolean hasEffect(Fluid booze) {
        BoozeEffect effect = CellarRegistry.instance().booze().getEffect(booze);
        if (effect != null) {
            return effect.isValid();
        }
        return false;
    }
}

