/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.brewing.BrewingRecipe;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.client.gui.GuiBrewKettle;
import growthcraft.cellar.client.resource.GrcCellarResources;
import growthcraft.core.integration.nei.TemplateRenderHelper;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class RecipeHandlerBrewKettle
extends TemplateRecipeHandler {
    public String getGuiTexture() {
        return GrcCellarResources.INSTANCE.textureGuiBrewKettle.toString();
    }

    public String getRecipeName() {
        return GrcI18n.translate("grc.recipe_handler.brew_kettle");
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBrewKettle.class;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<BrewingRecipe> recipes = CellarRegistry.instance().brewing().findRecipes(ingredient);
        for (BrewingRecipe recipe : recipes) {
            this.arecipes.add(new CachedBrewingRecipe(recipe));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawOutputFluidStacks(TemplateRecipeHandler.CachedRecipe recipe) {
        if (recipe instanceof CachedBrewingRecipe) {
            BrewingRecipe brewingRecipe = ((CachedBrewingRecipe)recipe).brewingRecipe;
            TemplateRenderHelper.drawFluidStack(41, 6, 16, 52, brewingRecipe.getInputFluidStack(), GrowthCraftCellar.getConfig().brewKettleMaxCap);
            TemplateRenderHelper.drawFluidStack(109, 6, 16, 52, brewingRecipe.getFluidStack(), GrowthCraftCellar.getConfig().brewKettleMaxCap);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawExtras(int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe != null) {
            this.drawOutputFluidStacks(crecipe);
        }
        GuiDraw.changeTexture((String)this.getGuiTexture());
        this.drawProgressBar(93, 19, 176, 0, 9, 28, 40, 1);
    }

    public class CachedBrewingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public BrewingRecipe brewingRecipe;
        protected PositionedStack ingredient;
        protected PositionedStack otherStack;

        public CachedBrewingRecipe(BrewingRecipe recipe) {
            super((TemplateRecipeHandler)RecipeHandlerBrewKettle.this);
            this.brewingRecipe = recipe;
            this.ingredient = new PositionedStack(this.brewingRecipe.getInputItemStack().getItemStacks(), 75, 24);
            if (this.brewingRecipe.hasResidue()) {
                this.otherStack = new PositionedStack((Object)this.brewingRecipe.getResidue().residueItem, 136, 6);
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return this.ingredient;
        }

        public PositionedStack getOtherStack() {
            return this.otherStack;
        }
    }
}

