/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.cellar.yeast.IYeastRegistry;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.item.WeightedItemStack;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.core.common.tileentity.device.DeviceFluidSlot;
import growthcraft.core.common.tileentity.device.DeviceInventorySlot;
import growthcraft.core.common.tileentity.device.DeviceProgressive;
import growthcraft.core.util.ItemUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class YeastGenerator
extends DeviceProgressive {
    protected int consumption = 75;
    protected DeviceFluidSlot fluidSlot;
    protected DeviceInventorySlot invSlot;
    protected Set<WeightedItemStack> tempItemList = new HashSet<WeightedItemStack>();

    public YeastGenerator(TileEntityCellarDevice te, int fluidSlotIndex, int invSlotIndex) {
        super(te);
        this.fluidSlot = new DeviceFluidSlot(te, fluidSlotIndex);
        this.invSlot = new DeviceInventorySlot((IInventory)te, invSlotIndex);
        this.setTimeMax(1200);
    }

    public YeastGenerator setConsumption(int c) {
        this.consumption = c;
        return this;
    }

    public BiomeGenBase getCurrentBiome() {
        return this.getWorld().func_72807_a(this.parent.field_145851_c, this.parent.field_145849_e);
    }

    public boolean canReplicateYeast(ItemStack stack) {
        if (stack.field_77994_a >= stack.func_77976_d()) {
            return false;
        }
        return CellarRegistry.instance().yeast().isYeast(stack);
    }

    public boolean canProduceYeast() {
        if (this.fluidSlot.getAmount() < this.consumption) {
            return false;
        }
        ItemStack yeastItem = this.invSlot.get();
        if (yeastItem != null && !this.canReplicateYeast(yeastItem)) {
            return false;
        }
        return CoreRegistry.instance().fluidDictionary().hasFluidTags(this.fluidSlot.getFluid(), BoozeTag.YOUNG);
    }

    public void consumeFluid() {
        this.fluidSlot.consume(this.consumption, true);
        this.markDirty();
    }

    protected void initProduceYeast() {
        this.tempItemList.clear();
        BiomeGenBase biome = this.getCurrentBiome();
        if (biome != null) {
            WeightedItemStack weightedItemStack;
            IYeastRegistry reg = CellarRegistry.instance().yeast();
            BiomeDictionary.Type[] yl = reg.getYeastListForBiomeName(biome.field_76791_y);
            if (yl != null) {
                this.tempItemList.addAll((Collection<WeightedItemStack>)yl);
            }
            for (BiomeDictionary.Type t : BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
                Set<WeightedItemStack> yeastList = reg.getYeastListForBiomeType(t);
                if (yeastList == null) continue;
                this.tempItemList.addAll(yeastList);
            }
            if (this.tempItemList.size() > 0 && (weightedItemStack = (WeightedItemStack)WeightedRandom.func_76271_a((Random)this.getWorld().field_73012_v, this.tempItemList)) != null && weightedItemStack.itemStack != null) {
                ItemStack result = weightedItemStack.itemStack.func_77946_l();
                this.invSlot.set(result);
                this.consumeFluid();
            }
        }
    }

    public void produceYeast() {
        if (this.invSlot.isEmpty()) {
            this.initProduceYeast();
        } else {
            ItemStack contents = this.invSlot.get();
            if (this.canReplicateYeast(contents)) {
                this.invSlot.set(ItemUtils.increaseStack(contents));
                this.consumeFluid();
            }
        }
    }

    @Override
    public void update() {
        if (this.canProduceYeast()) {
            this.increaseTime();
            if (this.time >= this.timeMax) {
                this.resetTime();
                this.produceYeast();
                this.markDirty();
            }
        } else if (this.resetTime()) {
            this.markDirty();
        }
    }
}

