/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.cellar.pressing.PressingRecipe;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.core.common.tileentity.device.DeviceFluidSlot;
import growthcraft.core.common.tileentity.device.DeviceInventorySlot;
import growthcraft.core.common.tileentity.device.DeviceProgressive;
import growthcraft.core.util.ItemUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FruitPress
extends DeviceProgressive {
    private float pomace;
    private DeviceFluidSlot fluidSlot;
    private DeviceInventorySlot inputSlot;
    private DeviceInventorySlot residueSlot;
    private PressingRecipe currentResult;

    public FruitPress(TileEntityCellarDevice te, int fs, int is, int rs) {
        super(te);
        this.fluidSlot = new DeviceFluidSlot(te, fs);
        this.inputSlot = new DeviceInventorySlot((IInventory)te, is);
        this.residueSlot = new DeviceInventorySlot((IInventory)te, rs);
    }

    public int getPresserMetadata() {
        return this.getWorld().func_72805_g(this.parent.field_145851_c, this.parent.field_145848_d + 1, this.parent.field_145849_e);
    }

    private boolean preparePressing() {
        this.currentResult = null;
        ItemStack primarySlotItem = this.inputSlot.get();
        if (primarySlotItem == null) {
            return false;
        }
        int m = this.getPresserMetadata();
        if (m < 2) {
            return false;
        }
        if (this.fluidSlot.isFull()) {
            return false;
        }
        PressingRecipe result = CellarRegistry.instance().pressing().getPressingRecipe(primarySlotItem);
        if (result == null) {
            return false;
        }
        if (!this.inputSlot.hasEnough(result.getInput())) {
            return false;
        }
        this.currentResult = result;
        this.setTimeMax(this.currentResult.getTime());
        if (this.fluidSlot.isEmpty()) {
            return true;
        }
        FluidStack stack = this.currentResult.getFluidStack();
        return stack.isFluidEqual(this.fluidSlot.get());
    }

    public void producePomace() {
        if (this.currentResult == null) {
            return;
        }
        Residue residue = this.currentResult.getResidue();
        if (residue != null) {
            this.pomace += residue.pomaceRate;
            if (this.pomace >= 1.0f) {
                this.pomace -= 1.0f;
                ItemStack residueResult = ItemUtils.mergeStacks(this.residueSlot.get(), residue.residueItem);
                if (residueResult != null) {
                    this.residueSlot.set(residueResult);
                }
            }
        }
    }

    public void pressItem() {
        if (this.currentResult == null) {
            return;
        }
        ItemStack pressingItem = this.inputSlot.get();
        this.producePomace();
        FluidStack fluidstack = this.currentResult.getFluidStack();
        this.fluidSlot.fill(fluidstack, true);
        this.inputSlot.consume(this.currentResult.getInput());
    }

    @Override
    public void update() {
        if (this.preparePressing()) {
            this.increaseTime();
            if (this.getTime() >= this.getTimeMax()) {
                this.resetTime();
                this.pressItem();
                this.markDirty();
            }
        } else if (this.resetTime()) {
            this.markDirty();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.pomace = data.func_74760_g("pomace");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74776_a("pomace", this.pomace);
    }
}

