/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.component;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.heatsource.IHeatSourceBlock;
import growthcraft.core.util.BlockCheck;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class HeatBlockComponent {
    private TileEntity tileEntity;
    private ForgeDirection sourceDir = ForgeDirection.DOWN;
    private float adjacentHeating;

    public HeatBlockComponent(TileEntity te, float adh) {
        this.tileEntity = te;
        this.adjacentHeating = adh;
    }

    private World getWorld() {
        return this.tileEntity.func_145831_w();
    }

    public float getHeatMultiplierFromDir(ForgeDirection dir) {
        int x = this.tileEntity.field_145851_c + dir.offsetX;
        int y = this.tileEntity.field_145848_d + dir.offsetY;
        int z = this.tileEntity.field_145849_e + dir.offsetZ;
        Block block = this.getWorld().func_147439_a(x, y, z);
        int meta = this.getWorld().func_72805_g(x, y, z);
        IHeatSourceBlock heatSource = CellarRegistry.instance().heatSource().getHeatSource(block, meta);
        if (heatSource != null) {
            return heatSource.getHeat(this.getWorld(), x, y, z);
        }
        return 0.0f;
    }

    public float getHeatMultiplierForAdjacent() {
        if (this.adjacentHeating > 0.0f) {
            float heat = 0.0f;
            for (ForgeDirection dir : BlockCheck.DIR4) {
                heat += this.getHeatMultiplierFromDir(dir);
            }
            return heat * this.adjacentHeating;
        }
        return 0.0f;
    }

    public float getHeatMultiplier() {
        return this.getHeatMultiplierFromDir(this.sourceDir) + this.getHeatMultiplierForAdjacent();
    }
}

