/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.booze.BoozeEntry;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.util.BoozeUtils;
import growthcraft.core.common.item.GrcItemFoodBase;
import growthcraft.core.common.item.IFluidItem;
import growthcraft.core.lib.GrcCoreState;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class ItemBoozeBottle
extends GrcItemFoodBase
implements IFluidItem {
    private Fluid[] boozes;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottle;
    @SideOnly(value=Side.CLIENT)
    private IIcon contents;

    public ItemBoozeBottle(Fluid[] boozeAry) {
        super(0, 0.0f, false);
        this.func_77848_i();
        this.func_77625_d(4);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77642_a(Items.field_151069_bo);
        this.func_77637_a(GrowthCraftCellar.tab);
        this.boozes = boozeAry;
    }

    public Fluid[] getFluidArray() {
        return this.boozes;
    }

    public Fluid getFluidByIndex(int i) {
        return i < 0 || i >= this.boozes.length ? this.boozes[0] : this.boozes[i];
    }

    @Override
    public Fluid getFluid(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return this.getFluidByIndex(stack.func_77960_j());
    }

    public BoozeEntry getBoozeEntry(ItemStack stack) {
        Fluid fluid = this.getFluid(stack);
        if (fluid != null) {
            return CellarRegistry.instance().booze().getBoozeEntry(fluid);
        }
        return null;
    }

    public int func_150905_g(ItemStack stack) {
        BoozeEntry entry = this.getBoozeEntry(stack);
        if (entry != null) {
            return entry.getHealAmount();
        }
        return 0;
    }

    public float func_150906_h(ItemStack stack) {
        BoozeEntry entry = this.getBoozeEntry(stack);
        if (entry != null) {
            return entry.getSaturation();
        }
        return 0.0f;
    }

    public int getColor(ItemStack stack) {
        Fluid booze = this.getFluid(stack);
        if (booze != null) {
            return booze.getColor();
        }
        return 0xFFFFFF;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (stack.func_77960_j() >= this.getFluidArray().length) {
            stack.func_77964_b(0);
        }
    }

    @Override
    protected void applyIEffects(ItemStack itemStack, World world, EntityPlayer player) {
        super.applyIEffects(itemStack, world, player);
        BoozeUtils.addEffects(this.getFluid(itemStack), itemStack, world, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        boolean showDetailed = GrcCoreState.showDetailedInformation();
        BoozeUtils.addBottleInformation(this.getFluid(stack), stack, player, list, bool, showDetailed);
        if (!showDetailed) {
            list.add(EnumChatFormatting.GRAY + GrcI18n.translate("grc.tooltip.detailed_information", EnumChatFormatting.WHITE + "SHIFT" + EnumChatFormatting.GRAY));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.bottle = reg.func_94245_a("grccellar:booze");
        this.contents = reg.func_94245_a("grccellar:booze_contents");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int par1, int pass) {
        return pass == 0 ? this.contents : this.bottle;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        return pass == 0 ? this.getColor(stack) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return BoozeUtils.hasEffect(this.getFluid(stack));
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a();
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    @Override
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public String func_77653_i(ItemStack stack) {
        Fluid booze = this.getFluid(stack);
        if (booze != null) {
            return GrcI18n.translate(booze.getUnlocalizedName());
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.getFluidArray().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }
}

