/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.client.render.RenderFruitPresser;
import growthcraft.cellar.common.block.BlockCellarContainer;
import growthcraft.cellar.common.block.BlockFruitPress;
import growthcraft.cellar.common.tileentity.TileEntityFruitPresser;
import growthcraft.core.common.block.IRotatableBlock;
import growthcraft.core.common.block.IWrenchable;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFruitPresser
extends BlockCellarContainer
implements IWrenchable,
IRotatableBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockFruitPresser() {
        super(Material.field_76233_E);
        this.field_149758_A = true;
        this.setTileEntityType(TileEntityFruitPresser.class);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149780_i);
        this.func_149663_c("grc.fruitPresser");
        this.func_149647_a(null);
        this.func_149676_a(0.1875f, 0.0f, 0.1875f, 0.8125f, 0.9375f, 0.8125f);
    }

    public String getPressStateName(int meta) {
        switch (meta) {
            case 0: 
            case 1: {
                return "unpressed";
            }
            case 2: 
            case 3: {
                return "pressed";
            }
        }
        return "invalid";
    }

    @Override
    public boolean isRotatable(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        Block below = world.func_147439_a(x, y - 1, z);
        if (below instanceof IRotatableBlock) {
            return ((IRotatableBlock)below).isRotatable(world, x, y - 1, z, side);
        }
        return false;
    }

    @Override
    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection side) {
        if (this.isRotatable((IBlockAccess)world, x, y, z, side)) {
            Block below = world.func_147439_a(x, y - 1, z);
            return below.rotateBlock(world, x, y - 1, z, side);
        }
        return false;
    }

    @Override
    public boolean wrenchBlock(World world, int x, int y, int z, EntityPlayer player, ItemStack wrench) {
        Block below = world.func_147439_a(x, y - 1, z);
        if (below instanceof BlockFruitPress) {
            return ((BlockFruitPress)below).wrenchBlock(world, x, y - 1, z, player, wrench);
        }
        return false;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        Block below = world.func_147439_a(x, y - 1, z);
        if (below instanceof BlockFruitPress) {
            return ((BlockFruitPress)below).tryWrenchItem(player, world, x, y - 1, z);
        }
        return false;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        int m = world.func_72805_g(x, y - 1, z);
        world.func_72921_c(x, y, z, m, 3);
        if (!world.field_72995_K) {
            this.updatePressState(world, x, y, z);
        }
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int m = world.func_72805_g(x, y - 1, z);
        world.func_72921_c(x, y, z, m, 3);
        if (!world.field_72995_K) {
            this.updatePressState(world, x, y, z);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147480_a(x, y, z, true);
        }
        if (!world.field_72995_K) {
            this.updatePressState(world, x, y, z);
        }
    }

    private void updatePressState(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        boolean flag = world.func_72864_z(x, y, z);
        if (flag && (meta == 0 || meta == 1)) {
            world.func_72921_c(x, y, z, meta | 2, 3);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (!(flag || meta != 2 && meta != 3)) {
            world.func_72921_c(x, y, z, meta & 1, 3);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, world.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        world.func_147471_g(x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return GrowthCraftCellar.blocks.fruitPress.getBlock() == world.func_147439_a(x, y - 1, z);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 || meta == 2) {
            return side == ForgeDirection.EAST || side == ForgeDirection.WEST;
        }
        if (meta == 1 || meta == 3) {
            return side == ForgeDirection.NORTH || side == ForgeDirection.SOUTH;
        }
        return this.isNormalCube(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return GrowthCraftCellar.blocks.fruitPress.getItem();
    }

    public Item func_149650_a(int par1, Random random, int par3) {
        return null;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[4];
        this.icons[0] = reg.func_94245_a("grccellar:fruitpresser_0");
        this.icons[1] = reg.func_94245_a("grccellar:fruitpresser_1");
        this.icons[2] = reg.func_94245_a("grccellar:fruitpresser_2");
        this.icons[3] = reg.func_94245_a("planks_oak");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconByIndex(int index) {
        return this.icons[index];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 0 ? this.icons[0] : (side == 1 ? this.icons[1] : this.icons[2]);
    }

    public int func_149645_b() {
        return RenderFruitPresser.RENDER_ID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }
}

