/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.fluids.FluidTag;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.client.gui.GuiCellar;
import growthcraft.cellar.client.gui.widget.GuiButtonDiscard;
import growthcraft.cellar.client.resource.GrcCellarResources;
import growthcraft.cellar.common.inventory.ContainerFermentBarrel;
import growthcraft.cellar.common.tileentity.TileEntityFermentBarrel;
import growthcraft.cellar.network.PacketClearTankButton;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFermentBarrel
extends GuiCellar<ContainerFermentBarrel, TileEntityFermentBarrel> {
    private GuiButtonDiscard button;

    public GuiFermentBarrel(InventoryPlayer inv, TileEntityFermentBarrel fermentBarrel) {
        super(GrcCellarResources.INSTANCE.textureGuiFermentBarrel, new ContainerFermentBarrel(inv, fermentBarrel), fermentBarrel);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (GrowthCraftCellar.getConfig().enableDiscardButton) {
            this.button = new GuiButtonDiscard(this.guiResource, 1, this.field_147003_i + 116, this.field_147009_r + 54);
            this.field_146292_n.add(this.button);
            this.button.field_146124_l = false;
        }
        this.addTooltipIndex("fluidtank.primary", 63, 17, 50, 52);
        this.addTooltipIndex("progress_indicator", 42, 22, 3, 26);
        if (this.button != null) {
            this.addTooltipIndex("discard.fluidtank.primary", 116, 54, 16, 16);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.button != null) {
            this.button.field_146124_l = ((TileEntityFermentBarrel)this.tileEntity).isFluidTankFilled(0);
        }
    }

    protected void func_146284_a(GuiButton butn) {
        GrowthCraftCellar.packetPipeline.sendToServer(new PacketClearTankButton(((TileEntityFermentBarrel)this.tileEntity).field_145851_c, ((TileEntityFermentBarrel)this.tileEntity).field_145848_d, ((TileEntityFermentBarrel)this.tileEntity).field_145849_e));
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        int i;
        super.func_146976_a(par1, par2, par3);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int x = this.getGuiX();
        int y = this.getGuiY();
        if (((TileEntityFermentBarrel)this.tileEntity).getTime() > 0) {
            int k1;
            i = ((TileEntityFermentBarrel)this.tileEntity).getDeviceProgressScaled(29);
            if (i > 0) {
                this.func_73729_b(x + 39, y + 21 + 29 - i, 188, 29 - i, 9, i);
            }
            if ((i = (k1 = ((TileEntityFermentBarrel)this.tileEntity).getTime() / 2 % 60) * 29 / 60) > 0) {
                this.func_73729_b(x + 49, y + 20 + 29 - i, 176, 29 - i, 12, i);
            }
        }
        if ((i = ((TileEntityFermentBarrel)this.tileEntity).getFluidAmountScaled(52, 0)) > 0) {
            FluidStack fluid = ((TileEntityFermentBarrel)this.tileEntity).getFluidStack(0);
            this.drawTank(x, y, 63, 17, 50, 52, i, fluid, ((TileEntityFermentBarrel)this.tileEntity).getFluidTank(0));
            this.bindGuiTexture();
            GuiFermentBarrel.field_146296_j.field_77023_b = 100.0f;
            Collection<FluidTag> tags = CoreRegistry.instance().fluidDictionary().getFluidTags(fluid);
            if (tags != null) {
                if (tags.contains(BoozeTag.FERMENTED)) {
                    field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, new ItemStack(Items.field_151075_bm), x + 114, y + 16);
                }
                if (tags.contains(BoozeTag.EXTENDED)) {
                    field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, new ItemStack(Items.field_151137_ax), x + 114, y + 32);
                }
                if (tags.contains(BoozeTag.POTENT)) {
                    field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, new ItemStack(Items.field_151114_aO), x + 130, y + 32);
                }
            }
            GuiFermentBarrel.field_146296_j.field_77023_b = 0.0f;
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        if (!((TileEntityFermentBarrel)this.tileEntity).isFluidTankEmpty(0)) {
            String s = String.valueOf(((TileEntityFermentBarrel)this.tileEntity).getFluidAmount(0));
            this.field_146289_q.func_78261_a(s, this.field_146999_f - 62 - this.field_146289_q.func_78256_a(s), this.field_147000_g - 104, 0xFFFFFF);
        }
    }

    @Override
    public void addTooltips(String handle, List<String> tooltip) {
        switch (handle) {
            case "progress_indicator": {
                tooltip.add(GrcI18n.translate("gui.grc.progress.format", EnumChatFormatting.GRAY + GrcI18n.translate("gui.grccellar.ferment_barrel.progress_name"), "" + EnumChatFormatting.WHITE + ((TileEntityFermentBarrel)this.tileEntity).getTime(), "" + EnumChatFormatting.GRAY + ((TileEntityFermentBarrel)this.tileEntity).getTimeMax()));
                break;
            }
            case "fluidtank.primary": {
                if (!((TileEntityFermentBarrel)this.tileEntity).isFluidTankFilled(0)) break;
                this.addFermentTooltips(((TileEntityFermentBarrel)this.tileEntity).getFluidStack(0), tooltip);
                break;
            }
            case "discard.fluidtank.primary": {
                tooltip.add(GrcI18n.translate("gui.grc.discard"));
                break;
            }
        }
    }
}

