/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.integration.waila;

import cpw.mods.fml.common.Optional;
import growthcraft.api.core.nbt.NBTHelper;
import growthcraft.bees.common.tileentity.TileEntityBeeBox;
import growthcraft.bees.util.TagFormatterBeeBox;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BeesDataProvider
implements IWailaDataProvider {
    @Optional.Method(modid="Waila")
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getTileEntity() instanceof TileEntityBeeBox) {
            NBTTagCompound tag = accessor.getNBTData();
            tooltip = TagFormatterBeeBox.INSTANCE.format(tooltip, tag);
        }
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof TileEntityBeeBox) {
            TileEntityBeeBox beeBox = (TileEntityBeeBox)te;
            tag.func_74757_a("has_bonus", beeBox.hasBonus());
            tag.func_74768_a("honeycomb_count", beeBox.countCombs());
            tag.func_74768_a("honeycomb_max", beeBox.getHoneyCombMax());
            tag.func_74768_a("honey_count", beeBox.countHoney());
            tag.func_74776_a("growth_rate", beeBox.getGrowthRate());
            tag.func_74782_a("bee", (NBTBase)NBTHelper.writeItemStackToNBT(beeBox.getBeeStack()));
        }
        return tag;
    }
}

