/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import growthcraft.api.bees.BeesFluidTag;
import growthcraft.api.bees.BeesRegistry;
import growthcraft.api.bees.user.UserBeesConfig;
import growthcraft.api.bees.user.UserFlowerEntry;
import growthcraft.api.bees.user.UserFlowersConfig;
import growthcraft.api.core.fluids.TaggedFluidStacks;
import growthcraft.api.core.item.recipes.ShapelessMultiRecipe;
import growthcraft.api.core.log.GrcLogger;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.bees.GrcBeesConfig;
import growthcraft.bees.client.eventhandler.GrcBeesHandleTextureStitch;
import growthcraft.bees.common.CommonProxy;
import growthcraft.bees.common.tileentity.TileEntityBeeBox;
import growthcraft.bees.common.village.ComponentVillageApiarist;
import growthcraft.bees.common.village.VillageHandlerBees;
import growthcraft.bees.common.village.VillageHandlerBeesApiarist;
import growthcraft.bees.common.world.WorldGeneratorBees;
import growthcraft.bees.creativetab.CreativeTabsGrowthcraftBees;
import growthcraft.bees.init.GrcBeesBlocks;
import growthcraft.bees.init.GrcBeesFluids;
import growthcraft.bees.init.GrcBeesItems;
import growthcraft.bees.init.GrcBeesRecipes;
import growthcraft.bees.integration.BoPModule;
import growthcraft.bees.integration.BotaniaModule;
import growthcraft.bees.integration.ForestryModule;
import growthcraft.bees.integration.GrcBambooModule;
import growthcraft.bees.integration.GrcNetherModule;
import growthcraft.bees.integration.NaturaModule;
import growthcraft.bees.integration.ThaumcraftModule;
import growthcraft.bees.integration.Waila;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.core.GrcGuiProvider;
import growthcraft.core.common.definition.BlockDefinition;
import growthcraft.core.integration.bop.BopPlatform;
import growthcraft.core.util.MapGenHelper;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="Growthcraft|Bees", name="Growthcraft Bees", version="1.7.10-2.7.3", dependencies="required-after:Growthcraft@1.7.10-2.7.3;required-after:Growthcraft|Cellar@1.7.10-2.7.3;after:Forestry")
public class GrowthCraftBees {
    public static final String MOD_ID = "Growthcraft|Bees";
    public static final String MOD_NAME = "Growthcraft Bees";
    public static final String MOD_VERSION = "1.7.10-2.7.3";
    @Mod.Instance(value="Growthcraft|Bees")
    public static GrowthCraftBees instance;
    public static CreativeTabs tab;
    public static final GrcBeesBlocks blocks;
    public static final GrcBeesItems items;
    public static final GrcBeesFluids fluids;
    public static final GrcGuiProvider guiProvider;
    private final ILogger logger = new GrcLogger("Growthcraft|Bees");
    private final GrcBeesConfig config = new GrcBeesConfig();
    private final ModuleContainer modules = new ModuleContainer();
    private final UserBeesConfig userBeesConfig = new UserBeesConfig();
    private final UserFlowersConfig userFlowersConfig = new UserFlowersConfig();
    private final GrcBeesRecipes recipes = new GrcBeesRecipes();

    public static UserBeesConfig getUserBeesConfig() {
        return GrowthCraftBees.instance.userBeesConfig;
    }

    public static ILogger getLogger() {
        return GrowthCraftBees.instance.logger;
    }

    public static GrcBeesConfig getConfig() {
        return GrowthCraftBees.instance.config;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config.setLogger(this.logger);
        this.config.load(event.getModConfigurationDirectory(), "growthcraft/bees.conf");
        this.modules.add(blocks);
        this.modules.add(items);
        this.modules.add(fluids);
        this.modules.add(this.recipes);
        this.userBeesConfig.setConfigFile(event.getModConfigurationDirectory(), "growthcraft/bees/bees.json");
        this.modules.add(this.userBeesConfig);
        this.userFlowersConfig.setConfigFile(event.getModConfigurationDirectory(), "growthcraft/bees/flowers.json");
        this.modules.add(this.userFlowersConfig);
        if (this.config.enableGrcBambooIntegration) {
            this.modules.add(new GrcBambooModule());
        }
        if (this.config.enableGrcNetherIntegration) {
            this.modules.add(new GrcNetherModule());
        }
        if (this.config.enableWailaIntegration) {
            this.modules.add(new Waila());
        }
        if (this.config.enableBoPIntegration) {
            this.modules.add(new BoPModule());
        }
        if (this.config.enableNaturaIntegration) {
            this.modules.add(new NaturaModule());
        }
        if (this.config.enableBotaniaIntegration) {
            this.modules.add(new BotaniaModule());
        }
        if (this.config.enableForestryIntegration) {
            this.modules.add(new ForestryModule());
        }
        if (this.config.enableThaumcraftIntegration) {
            this.modules.add(new ThaumcraftModule());
        }
        this.modules.add(CommonProxy.instance);
        if (this.config.debugEnabled) {
            BeesRegistry.instance().setLogger(this.logger);
            this.modules.setLogger(this.logger);
        }
        this.modules.freeze();
        tab = new CreativeTabsGrowthcraftBees("creative_tab_grcbees");
        MinecraftForge.EVENT_BUS.register((Object)new GrcBeesHandleTextureStitch());
        this.modules.preInit();
        this.register();
    }

    private void register() {
        GameRegistry.registerTileEntity(TileEntityBeeBox.class, (String)"grc.tileentity.beeBox");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorBees(), (int)0);
        MapGenHelper.registerVillageStructure(ComponentVillageApiarist.class, "grc.apiarist");
        this.modules.register();
        this.registerRecipes();
        this.userBeesConfig.addDefault(GrowthCraftBees.items.bee.asStack()).setComment("Growthcraft's default bee");
        BeesRegistry.instance().addHoneyComb(GrowthCraftBees.items.honeyCombEmpty.asStack(), GrowthCraftBees.items.honeyCombFilled.asStack());
        this.userFlowersConfig.addDefault((Block)Blocks.field_150328_O);
        this.userFlowersConfig.addDefault((Block)Blocks.field_150327_N);
        if (BopPlatform.isLoaded()) {
            this.userFlowersConfig.addDefault(new UserFlowerEntry("BiomesOPlenty", "flowers", Short.MAX_VALUE).setEntryType("forced")).setComment("BiomesOPlenty flowers require a forced entry, in order for it to be placed by the bee box spawning.");
            this.userFlowersConfig.addDefault(new UserFlowerEntry("BiomesOPlenty", "flowers2", Short.MAX_VALUE).setEntryType("forced")).setComment("BiomesOPlenty flowers require a forced entry, in order for it to be placed by the bee box spawning.");
        }
    }

    private void registerRecipes() {
        BlockDefinition planks = new BlockDefinition(Blocks.field_150344_f);
        for (int i = 0; i < 6; ++i) {
            GameRegistry.addRecipe((ItemStack)GrowthCraftBees.blocks.beeBox.asStack(1, i), (Object[])new Object[]{" A ", "A A", "AAA", Character.valueOf('A'), planks.asStack(1, i)});
        }
        ItemStack honeyStack = GrowthCraftBees.items.honeyCombFilled.asStack();
        GameRegistry.addShapelessRecipe((ItemStack)GrowthCraftBees.items.honeyJar.asStack(), (Object[])new Object[]{honeyStack, honeyStack, honeyStack, honeyStack, honeyStack, honeyStack, Items.field_151162_bE});
    }

    private void postRegisterRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GrowthCraftBees.blocks.beeBox.asStack(), new Object[]{" A ", "A A", "AAA", Character.valueOf('A'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessMultiRecipe(GrowthCraftBees.items.honeyJar.asStack(), new TaggedFluidStacks(1000, BeesFluidTag.HONEY.getName()), Items.field_151162_bE));
    }

    private void initVillageHandlers() {
        VillageHandlerBeesApiarist handler = new VillageHandlerBeesApiarist();
        int brewerID = GrowthCraftCellar.getConfig().villagerBrewerID;
        int apiaristID = this.config.villagerApiaristID;
        if (apiaristID > 0) {
            VillagerRegistry.instance().registerVillagerId(apiaristID);
            VillagerRegistry.instance().registerVillageTradeHandler(apiaristID, (VillagerRegistry.IVillageTradeHandler)handler);
        }
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)handler);
        if (brewerID > 0) {
            VillagerRegistry.instance().registerVillageTradeHandler(brewerID, (VillagerRegistry.IVillageTradeHandler)new VillageHandlerBees());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)guiProvider);
        if (this.config.enableVillageGen) {
            this.initVillageHandlers();
        }
        this.modules.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.userBeesConfig.loadUserConfig();
        this.userFlowersConfig.loadUserConfig();
        this.postRegisterRecipes();
        this.modules.postInit();
    }

    static {
        blocks = new GrcBeesBlocks();
        items = new GrcBeesItems();
        fluids = new GrcBeesFluids();
        guiProvider = new GrcGuiProvider(new GrcLogger("Growthcraft|Bees:GuiProvider"));
    }
}

