/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bamboo.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.bamboo.GrowthCraftBamboo;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockBambooLeaves
extends BlockLeavesBase
implements IShearable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private int[] adjacentTreeBlocks;

    public BlockBambooLeaves() {
        super(Material.field_151584_j, false);
        this.func_149713_g(1);
        this.func_149672_a(field_149779_h);
        this.func_149711_c(0.2f);
        this.func_149675_a(true);
        this.func_149663_c("grc.bambooLeaves");
        this.func_149647_a(GrowthCraftBamboo.creativeTab);
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta;
        if (!world.field_72995_K && ((meta = world.func_72805_g(x, y, z)) & 8) != 0 && (meta & 4) == 0) {
            int l1;
            int b0 = 4;
            int i1 = 5;
            int b1 = 32;
            int j1 = 1024;
            int k1 = 16;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[32768];
            }
            if (world.func_72904_c(x - 5, y - 5, z - 5, x + 5, y + 5, z + 5)) {
                int j2;
                int i2;
                for (l1 = -4; l1 <= 4; ++l1) {
                    for (i2 = -4; i2 <= 4; ++i2) {
                        for (j2 = -4; j2 <= 4; ++j2) {
                            Block block = world.func_147439_a(x + l1, y + i2, z + j2);
                            this.adjacentTreeBlocks[(l1 + 16) * 1024 + (i2 + 16) * 32 + j2 + 16] = block != null && block.canSustainLeaves((IBlockAccess)world, x + l1, y + i2, z + j2) ? 0 : (block != null && block.isLeaves((IBlockAccess)world, x + l1, y + i2, z + j2) ? -2 : -1);
                        }
                    }
                }
                for (l1 = 1; l1 <= 4; ++l1) {
                    for (i2 = -4; i2 <= 4; ++i2) {
                        for (j2 = -4; j2 <= 4; ++j2) {
                            for (int k2 = -4; k2 <= 4; ++k2) {
                                if (this.adjacentTreeBlocks[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] != l1 - 1) continue;
                                if (this.adjacentTreeBlocks[(i2 + 16 - 1) * 1024 + (j2 + 16) * 32 + k2 + 16] == -2) {
                                    this.adjacentTreeBlocks[(i2 + 16 - 1) * 1024 + (j2 + 16) * 32 + k2 + 16] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + 16 + 1) * 1024 + (j2 + 16) * 32 + k2 + 16] == -2) {
                                    this.adjacentTreeBlocks[(i2 + 16 + 1) * 1024 + (j2 + 16) * 32 + k2 + 16] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + 16) * 1024 + (j2 + 16 - 1) * 32 + k2 + 16] == -2) {
                                    this.adjacentTreeBlocks[(i2 + 16) * 1024 + (j2 + 16 - 1) * 32 + k2 + 16] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + 16) * 1024 + (j2 + 16 + 1) * 32 + k2 + 16] == -2) {
                                    this.adjacentTreeBlocks[(i2 + 16) * 1024 + (j2 + 16 + 1) * 32 + k2 + 16] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + 16) * 1024 + (j2 + 16) * 32 + (k2 + 16 - 1)] == -2) {
                                    this.adjacentTreeBlocks[(i2 + 16) * 1024 + (j2 + 16) * 32 + (k2 + 16 - 1)] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16 + 1] != -2) continue;
                                this.adjacentTreeBlocks[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16 + 1] = l1;
                            }
                        }
                    }
                }
            }
            if ((l1 = this.adjacentTreeBlocks[16912]) >= 0) {
                world.func_72921_c(x, y, z, meta & 0xFFFFFFF7, 4);
            } else {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        super.func_149734_b(world, x, y, z, random);
        if (world.func_72951_B(x, y + 1, z) && !World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && random.nextInt(15) == 1) {
            double d0 = (float)x + random.nextFloat();
            double d1 = (double)y - 0.05;
            double d2 = (float)z + random.nextFloat();
            world.func_72869_a("dripWater", d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        boolean b0 = true;
        int j1 = 2;
        if (world.func_72904_c(x - 2, y - 2, z - 2, x + 2, y + 2, z + 2)) {
            for (int k1 = -1; k1 <= 1; ++k1) {
                for (int l1 = -1; l1 <= 1; ++l1) {
                    for (int i2 = -1; i2 <= 1; ++i2) {
                        Block j2 = world.func_147439_a(x + k1, y + l1, z + i2);
                        if (j2 == null) continue;
                        j2.beginLeavesDecay(world, x + k1, y + l1, z + i2);
                    }
                }
            }
        }
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) | 8, 4);
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)this, 1, meta & 3);
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return null;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[2];
        this.icons[0] = reg.func_94245_a("grcbamboo:leaves");
        this.icons[1] = reg.func_94245_a("grcbamboo:leaves_opaque");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[this.func_149662_c() ? 1 : 0];
    }

    public boolean func_149662_c() {
        return Blocks.field_150362_t.func_149662_c();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        double d0 = 0.5;
        double d1 = 1.0;
        return ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return ColorizerFoliage.func_77468_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        int r = 0;
        int g = 0;
        int b = 0;
        for (int x1 = -1; x1 <= 1; ++x1) {
            for (int z1 = -1; z1 <= 1; ++z1) {
                int j2 = world.func_72807_a(x + z1, z + x1).func_150571_c(x + z1, y, z + x1);
                r += (j2 & 0xFF0000) >> 16;
                g += (j2 & 0xFF00) >> 8;
                b += j2 & 0xFF;
            }
        }
        return (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)Blocks.field_150362_t, 1, world.func_72805_g(x, y, z) & 3));
        return ret;
    }
}

