/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apples.common.world;

import growthcraft.apples.GrowthCraftApples;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenAppleTree
extends WorldGenerator {
    private final int minTreeHeight = 4;
    private final int metaWood = 0;
    private final int metaLeaves = 0;
    private final Block log = Blocks.field_150364_r;
    private final Block leaves;

    public WorldGenAppleTree(boolean doblocknotify) {
        super(doblocknotify);
        this.leaves = GrowthCraftApples.blocks.appleLeaves.getBlock();
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int l = random.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (y >= 1 && y + l + 1 <= 256) {
            Block block;
            int k1;
            int b0;
            for (int i1 = y; i1 <= y + 1 + l; ++i1) {
                b0 = 1;
                if (i1 == y) {
                    b0 = 0;
                }
                if (i1 >= y + 1 + l - 2) {
                    b0 = 2;
                }
                for (int j1 = x - b0; j1 <= x + b0 && flag; ++j1) {
                    for (k1 = z - b0; k1 <= z + b0 && flag; ++k1) {
                        if (i1 >= 0 && i1 < 256) {
                            block = world.func_147439_a(j1, i1, k1);
                            if (this.isReplaceable(world, j1, i1, k1)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block block2 = world.func_147439_a(x, y - 1, z);
            boolean isSoil = block2.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && y < 256 - l - 1) {
                block2.onPlantGrow(world, x, y - 1, z, x, y, z);
                b0 = 3;
                boolean b1 = false;
                for (k1 = y - b0 + l; k1 <= y + l; ++k1) {
                    int i3 = k1 - (y + l);
                    int l1 = 1 - i3 / 2;
                    for (int i2 = x - l1; i2 <= x + l1; ++i2) {
                        int j2 = i2 - x;
                        for (int k2 = z - l1; k2 <= z + l1; ++k2) {
                            Block block1;
                            int l2 = k2 - z;
                            if (Math.abs(j2) == l1 && Math.abs(l2) == l1 && (random.nextInt(2) == 0 || i3 == 0) || !(block1 = world.func_147439_a(i2, k1, k2)).isAir((IBlockAccess)world, i2, k1, k2) && !block1.isLeaves((IBlockAccess)world, i2, k1, k2)) continue;
                            ((Object)((Object)this)).getClass();
                            this.func_150516_a(world, i2, k1, k2, this.leaves, 0);
                        }
                    }
                }
                for (k1 = 0; k1 < l; ++k1) {
                    block = world.func_147439_a(x, y + k1, z);
                    if (!block.isAir((IBlockAccess)world, x, y + k1, z) && !block.isLeaves((IBlockAccess)world, x, y + k1, z)) continue;
                    ((Object)((Object)this)).getClass();
                    this.func_150516_a(world, x, y + k1, z, this.log, 0);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean func_150523_a(Block block) {
        return block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j || block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150364_r || block == Blocks.field_150363_s || block == Blocks.field_150345_g || block == Blocks.field_150395_bd;
    }

    protected boolean isReplaceable(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.isAir((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z) || block.isWood((IBlockAccess)world, x, y, z) || this.func_150523_a(block);
    }
}

