/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apples;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.log.GrcLogger;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.apples.GrcApplesConfig;
import growthcraft.apples.common.CommonProxy;
import growthcraft.apples.common.village.ComponentVillageAppleFarm;
import growthcraft.apples.common.village.VillageHandlerApples;
import growthcraft.apples.handler.AppleFuelHandler;
import growthcraft.apples.init.GrcApplesBlocks;
import growthcraft.apples.init.GrcApplesFluids;
import growthcraft.apples.init.GrcApplesItems;
import growthcraft.apples.init.GrcApplesRecipes;
import growthcraft.apples.integration.ForestryModule;
import growthcraft.apples.integration.MFRModule;
import growthcraft.apples.integration.ThaumcraftModule;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.integration.NEI;
import growthcraft.core.util.MapGenHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Growthcraft|Apples", name="Growthcraft Apples", version="1.7.10-2.7.3", dependencies="required-after:Growthcraft@1.7.10-2.7.3;required-after:Growthcraft|Cellar@1.7.10-2.7.3")
public class GrowthCraftApples {
    public static final String MOD_ID = "Growthcraft|Apples";
    public static final String MOD_NAME = "Growthcraft Apples";
    public static final String MOD_VERSION = "1.7.10-2.7.3";
    @Mod.Instance(value="Growthcraft|Apples")
    public static GrowthCraftApples instance;
    public static CreativeTabs creativeTab;
    public static final GrcApplesBlocks blocks;
    public static final GrcApplesItems items;
    public static final GrcApplesFluids fluids;
    private final ILogger logger = new GrcLogger("Growthcraft|Apples");
    private final GrcApplesConfig config = new GrcApplesConfig();
    private final ModuleContainer modules = new ModuleContainer();
    private final GrcApplesRecipes recipes = new GrcApplesRecipes();

    public static GrcApplesConfig getConfig() {
        return GrowthCraftApples.instance.config;
    }

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent event) {
        creativeTab = GrowthCraftCore.creativeTab;
        this.config.setLogger(this.logger);
        this.config.load(event.getModConfigurationDirectory(), "growthcraft/apples.conf");
        this.modules.add(blocks);
        this.modules.add(items);
        this.modules.add(fluids);
        this.modules.add(this.recipes);
        if (this.config.enableForestryIntegration) {
            this.modules.add(new ForestryModule());
        }
        if (this.config.enableMFRIntegration) {
            this.modules.add(new MFRModule());
        }
        if (this.config.enableThaumcraftIntegration) {
            this.modules.add(new ThaumcraftModule());
        }
        this.modules.add(CommonProxy.instance);
        if (this.config.debugEnabled) {
            this.modules.setLogger(this.logger);
        }
        this.modules.freeze();
        this.modules.preInit();
        this.register();
    }

    public void register() {
        MapGenHelper.registerVillageStructure(ComponentVillageAppleFarm.class, "grc.applefarm");
        GameRegistry.addShapelessRecipe((ItemStack)GrowthCraftApples.items.appleSeeds.asStack(), (Object[])new Object[]{Items.field_151034_e});
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameRegistry.registerFuelHandler((IFuelHandler)new AppleFuelHandler());
        NEI.hideItem(GrowthCraftApples.blocks.appleBlock.asStack());
        this.modules.register();
    }

    private void initVillageHandlers() {
        VillageHandlerApples handler = new VillageHandlerApples();
        int brewerID = GrowthCraftCellar.getConfig().villagerBrewerID;
        if (brewerID > 0) {
            VillagerRegistry.instance().registerVillageTradeHandler(brewerID, (VillagerRegistry.IVillageTradeHandler)handler);
        }
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)handler);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (this.config.enableVillageGen) {
            this.initVillageHandlers();
        }
        this.modules.init();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPost(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            for (int i = 0; i < GrowthCraftApples.fluids.appleCiderBooze.length; ++i) {
                GrowthCraftApples.fluids.appleCiderBooze[i].setIcons(GrowthCraftCore.liquidSmoothTexture);
            }
        }
    }

    @Mod.EventHandler
    public void postload(FMLPostInitializationEvent event) {
        this.modules.postInit();
    }

    static {
        blocks = new GrcApplesBlocks();
        items = new GrcApplesItems();
        fluids = new GrcApplesFluids();
    }
}

