/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.milk.util;

import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.util.MultiStacksUtil;
import growthcraft.api.milk.MilkRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CheeseVatRecipeBuilder {
    private String label;
    private List<FluidStack> outputFluids = new ArrayList<FluidStack>();
    private List<ItemStack> outputStacks = new ArrayList<ItemStack>();
    private List<IMultiFluidStacks> inputFluids = new ArrayList<IMultiFluidStacks>();
    private List<IMultiItemStacks> inputStacks = new ArrayList<IMultiItemStacks>();

    public CheeseVatRecipeBuilder(String l) {
        this.label = l;
    }

    private void addFluidStacksToList(@Nonnull List<IMultiFluidStacks> list, Object ... objs) {
        for (Object obj : objs) {
            list.add(MultiStacksUtil.toMultiFluidStacks(obj));
        }
    }

    private void addItemStacksToList(@Nonnull List<IMultiItemStacks> list, Object ... objs) {
        for (Object obj : objs) {
            list.add(MultiStacksUtil.toMultiItemStacks(obj));
        }
    }

    public CheeseVatRecipeBuilder outputFluids(FluidStack ... objs) {
        this.outputFluids.addAll(Arrays.asList(objs));
        return this;
    }

    public CheeseVatRecipeBuilder outputItems(ItemStack ... objs) {
        this.outputStacks.addAll(Arrays.asList(objs));
        return this;
    }

    public CheeseVatRecipeBuilder inputFluids(Object ... objs) {
        this.addFluidStacksToList(this.inputFluids, objs);
        return this;
    }

    public CheeseVatRecipeBuilder inputItems(Object ... objs) {
        this.addItemStacksToList(this.inputStacks, objs);
        return this;
    }

    public CheeseVatRecipeBuilder register() {
        MilkRegistry.instance().cheeseVat().addRecipe(this.outputFluids, this.outputStacks, this.inputFluids, this.inputStacks);
        return this;
    }

    public static CheeseVatRecipeBuilder buildRecipe(String label) {
        return new CheeseVatRecipeBuilder(label);
    }
}

