/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.milk.cheesepress;

import growthcraft.api.core.item.ItemTest;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.milk.cheesepress.CheesePressRecipe;
import growthcraft.api.milk.cheesepress.ICheesePressRecipe;
import growthcraft.api.milk.cheesepress.ICheesePressRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class CheesePressRegistry
implements ICheesePressRegistry {
    private ILogger logger = NullLogger.INSTANCE;
    private List<ICheesePressRecipe> recipes = new ArrayList<ICheesePressRecipe>();

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public void addRecipe(@Nonnull ICheesePressRecipe recipe) {
        this.logger.debug("Adding new cheese press recipe {%s}", recipe);
        this.recipes.add(recipe);
    }

    @Override
    public void addRecipe(@Nonnull ItemStack stack, @Nonnull ItemStack output, int time) {
        this.addRecipe(new CheesePressRecipe(stack, output, time));
    }

    @Override
    public ICheesePressRecipe findRecipe(@Nullable ItemStack stack) {
        if (ItemTest.isValid(stack)) {
            for (ICheesePressRecipe recipe : this.recipes) {
                if (!recipe.isMatchingRecipe(stack)) continue;
                return recipe;
            }
        }
        return null;
    }
}

