/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.milk;

import growthcraft.api.core.log.ILoggable;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.milk.cheesepress.CheesePressRegistry;
import growthcraft.api.milk.cheesepress.ICheesePressRegistry;
import growthcraft.api.milk.cheesevat.CheeseVatRegistry;
import growthcraft.api.milk.cheesevat.ICheeseVatRegistry;
import growthcraft.api.milk.churn.ChurnRegistry;
import growthcraft.api.milk.churn.IChurnRegistry;
import growthcraft.api.milk.pancheon.IPancheonRegistry;
import growthcraft.api.milk.pancheon.PancheonRegistry;
import javax.annotation.Nonnull;

public class MilkRegistry
implements ILoggable {
    private static final MilkRegistry INSTANCE = new MilkRegistry();
    private final ICheesePressRegistry cheesePressRegistry = new CheesePressRegistry();
    private final ICheeseVatRegistry cheeseVatRegistry = new CheeseVatRegistry();
    private final IChurnRegistry churnRegistry = new ChurnRegistry();
    private final IPancheonRegistry pancheonRegistry = new PancheonRegistry();
    private ILogger logger = NullLogger.INSTANCE;

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
        this.cheesePressRegistry.setLogger(this.logger);
        this.cheeseVatRegistry.setLogger(this.logger);
        this.churnRegistry.setLogger(this.logger);
        this.pancheonRegistry.setLogger(this.logger);
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public static final MilkRegistry instance() {
        return INSTANCE;
    }

    public ICheesePressRegistry cheesePress() {
        return this.cheesePressRegistry;
    }

    public ICheeseVatRegistry cheeseVat() {
        return this.cheeseVatRegistry;
    }

    public IChurnRegistry churn() {
        return this.churnRegistry;
    }

    public IPancheonRegistry pancheon() {
        return this.pancheonRegistry;
    }
}

