/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.vines;

import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.core.vines.IVineDropRegistry;
import growthcraft.api.core.vines.IVineEntry;
import growthcraft.api.core.vines.VineDropEntry;
import growthcraft.api.core.vines.VineEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;

public class VineDropRegistry
implements IVineDropRegistry {
    private final Set<IVineEntry> vines = new HashSet<IVineEntry>();
    private final List<VineDropEntry> vineDrops = new ArrayList<VineDropEntry>();
    private ILogger logger = NullLogger.INSTANCE;

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    public List<VineDropEntry> getVineDropsList() {
        return this.vineDrops;
    }

    @Override
    public void addVineEntry(@Nonnull IVineEntry entry) {
        this.vines.add(entry);
    }

    @Override
    public void addVineEntry(@Nonnull Block block, int meta) {
        this.addVineEntry(new VineEntry(block, meta));
    }

    @Override
    public boolean isVine(@Nullable Block block, int meta) {
        for (IVineEntry entry : this.vines) {
            if (!entry.matches(block, meta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addDropEntry(@Nonnull VineDropEntry entry) {
        this.vineDrops.add(entry);
    }

    @Override
    public void addDropEntry(@Nonnull ItemStack item, int weight) {
        if (weight <= 0) {
            this.logger.warn("Weight was set to 0 for item {%s}, please fix this by setting it to 1 or greater.", item);
            weight = 1;
        }
        this.addDropEntry(new VineDropEntry(item, weight));
    }

    @Override
    public boolean hasVineDrops() {
        return !this.getVineDropsList().isEmpty();
    }

    @Override
    public ItemStack getVineDropItem(@Nonnull World world) {
        List<VineDropEntry> vineEntries = this.getVineDropsList();
        if (vineEntries.isEmpty()) {
            return null;
        }
        VineDropEntry entry = (VineDropEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, vineEntries);
        if (entry == null || entry.getItemStack() == null) {
            return null;
        }
        return entry.getItemStack().func_77946_l();
    }
}

