/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.util;

public class EasingTemplate {
    public final BackIn backIn = new BackIn();
    public final BackInOut backInOut = new BackInOut();
    public final BackOut backOut = new BackOut();
    public final BounceIn bounceIn = new BounceIn();
    public final BounceInOut bounceInOut = new BounceInOut();
    public final BounceOut bounceOut = new BounceOut();
    public final CircularIn circIn = new CircularIn();
    public final CircularInOut circInOut = new CircularInOut();
    public final CircularOut circOut = new CircularOut();
    public final CubicIn cubicIn = new CubicIn();
    public final CubicInOut cubicInOut = new CubicInOut();
    public final CubicOut cubicOut = new CubicOut();
    public final ElasticIn elasticIn = new ElasticIn();
    public final ElasticInOut elasticInOut = new ElasticInOut();
    public final ElasticOut elasticOut = new ElasticOut();
    public final ExponentialIn expoIn = new ExponentialIn();
    public final ExponentialInOut expoInOut = new ExponentialInOut();
    public final ExponentialOut expoOut = new ExponentialOut();
    public final Linear linear = new Linear();
    public final QuadraticIn quadIn = new QuadraticIn();
    public final QuadraticInOut quadInOut = new QuadraticInOut();
    public final QuadraticOut quadOut = new QuadraticOut();
    public final QuarticIn quartIn = new QuarticIn();
    public final QuarticInOut quartInOut = new QuarticInOut();
    public final QuarticOut quartOut = new QuarticOut();
    public final QuinticIn quintIn = new QuinticIn();
    public final QuinticInOut quintInOut = new QuinticInOut();
    public final QuinticOut quintOut = new QuinticOut();
    public final SinusoidalIn sineIn = new SinusoidalIn();
    public final SinusoidalInOut sineInOut = new SinusoidalInOut();
    public final SinusoidalOut sineOut = new SinusoidalOut();

    public static class BounceInOut
    implements EasingFunction {
        private final BounceIn bi = new BounceIn();
        private final BounceOut bo = new BounceOut();

        @Override
        public double call(double k) {
            if (k < 0.5) {
                return this.bi.call(k * 2.0) * 0.5;
            }
            return this.bo.call(k * 2.0 - 1.0) * 0.5 + 0.5;
        }
    }

    public static class BounceIn
    implements EasingFunction {
        private final BounceOut bo = new BounceOut();

        @Override
        public double call(double k) {
            return 1.0 - this.bo.call(1.0 - k);
        }
    }

    public static class BounceOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            if (k < 0.36363636363636365) {
                return 7.5625 * k * k;
            }
            if (k < 0.7272727272727273) {
                return 7.5625 * (k -= 0.5454545454545454) * k + 0.75;
            }
            if (k < 0.9090909090909091) {
                return 7.5625 * (k -= 0.8181818181818182) * k + 0.9375;
            }
            return 7.5625 * (k -= 0.9545454545454546) * k + 0.984375;
        }
    }

    public static class BackInOut
    implements EasingFunction {
        private final double s = 2.5949095;

        @Override
        public double call(double k) {
            double d;
            k *= 2.0;
            if (d < 1.0) {
                return 0.5 * (k * k * (3.5949095 * k - 2.5949095));
            }
            return 0.5 * ((k -= 2.0) * k * (3.5949095 * k + 2.5949095) + 2.0);
        }
    }

    public static class BackOut
    implements EasingFunction {
        private final double s = 1.70158;

        @Override
        public double call(double k) {
            return (k -= 1.0) * k * (2.70158 * k + 1.70158) + 1.0;
        }
    }

    public static class BackIn
    implements EasingFunction {
        private final double s = 1.70158;

        @Override
        public double call(double k) {
            return k * k * (2.70158 * k - 1.70158);
        }
    }

    public static class ElasticInOut
    implements EasingFunction {
        private final double p = 0.4;

        @Override
        public double call(double k) {
            double d;
            double s = 0.0;
            double a = 0.1;
            if (k == 0.0) {
                return 0.0;
            }
            if (k == 1.0) {
                return 1.0;
            }
            if (a == 0.0 || a < 1.0) {
                a = 1.0;
                s = 0.1;
            } else {
                s = 0.4 * Math.asin(1.0 / a) / (Math.PI * 2);
            }
            k *= 2.0;
            if (d < 1.0) {
                return -0.5 * (a * Math.pow(2.0, 10.0 * (k -= 1.0)) * Math.sin((k - s) * (Math.PI * 2) / 0.4));
            }
            return a * Math.pow(2.0, -10.0 * (k -= 1.0)) * Math.sin((k - s) * (Math.PI * 2) / 0.4) * 0.5 + 1.0;
        }
    }

    public static class ElasticOut
    implements EasingFunction {
        private final double p = 0.4;

        @Override
        public double call(double k) {
            double s = 0.0;
            double a = 0.1;
            if (k == 0.0) {
                return 0.0;
            }
            if (k == 1.0) {
                return 1.0;
            }
            if (a == 0.0 || a < 1.0) {
                a = 1.0;
                s = 0.1;
            } else {
                s = 0.4 * Math.asin(1.0 / a) / (Math.PI * 2);
            }
            return a * Math.pow(2.0, -10.0 * k) * Math.sin((k - s) * (Math.PI * 2) / 0.4) + 1.0;
        }
    }

    public static class ElasticIn
    implements EasingFunction {
        private final double p = 0.4;

        @Override
        public double call(double k) {
            double s = 0.0;
            double a = 0.1;
            if (k == 0.0) {
                return 0.0;
            }
            if (k == 1.0) {
                return 1.0;
            }
            if (s == 0.0 || a < 1.0) {
                a = 1.0;
                s = 0.1;
            } else {
                s = 0.4 * Math.asin(1.0 / a) / (Math.PI * 2);
            }
            return -(a * Math.pow(2.0, 10.0 * (k -= 1.0)) * Math.sin((k - s) * (Math.PI * 2) / 0.4));
        }
    }

    public static class CircularInOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            double d;
            k *= 2.0;
            if (d < 1.0) {
                return -0.5 * (Math.sqrt(1.0 - k * k) - 1.0);
            }
            return 0.5 * (Math.sqrt(1.0 - (k -= 2.0) * k) + 1.0);
        }
    }

    public static class CircularOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            return Math.sqrt(1.0 - (k -= 1.0) * k);
        }
    }

    public static class CircularIn
    implements EasingFunction {
        @Override
        public double call(double k) {
            return 1.0 - Math.sqrt(1.0 - k * k);
        }
    }

    public static class ExponentialInOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            double d;
            if (k == 0.0) {
                return 0.0;
            }
            if (k == 1.0) {
                return 1.0;
            }
            k *= 2.0;
            if (d < 1.0) {
                return 0.5 * Math.pow(1024.0, k - 1.0);
            }
            return 0.5 * (-Math.pow(2.0, -10.0 * (k - 1.0)) + 2.0);
        }
    }

    public static class ExponentialOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            return k == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * k);
        }
    }

    public static class ExponentialIn
    implements EasingFunction {
        @Override
        public double call(double k) {
            return k == 0.0 ? 0.0 : Math.pow(1024.0, k - 1.0);
        }
    }

    public static class SinusoidalInOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            return 0.5 * (1.0 - Math.cos(Math.PI * k));
        }
    }

    public static class SinusoidalOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            return Math.sin(k * Math.PI / 2.0);
        }
    }

    public static class SinusoidalIn
    implements EasingFunction {
        @Override
        public double call(double k) {
            return 1.0 - Math.cos(k * Math.PI / 2.0);
        }
    }

    public static class QuinticInOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            double d;
            k *= 2.0;
            if (d < 1.0) {
                return 0.5 * k * k * k * k * k;
            }
            return 0.5 * ((k -= 2.0) * k * k * k * k + 2.0);
        }
    }

    public static class QuinticOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            return (k -= 1.0) * k * k * k * k + 1.0;
        }
    }

    public static class QuinticIn
    implements EasingFunction {
        @Override
        public double call(double k) {
            return k * k * k * k * k;
        }
    }

    public static class QuarticInOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            double d;
            k *= 2.0;
            if (d < 1.0) {
                return 0.5 * k * k * k * k;
            }
            return -0.5 * ((k -= 2.0) * k * k * k - 2.0);
        }
    }

    public static class QuarticOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            return 1.0 - (k -= 1.0) * k * k * k;
        }
    }

    public static class QuarticIn
    implements EasingFunction {
        @Override
        public double call(double k) {
            return k * k * k * k;
        }
    }

    public static class CubicInOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            double d;
            k *= 2.0;
            if (d < 1.0) {
                return 0.5 * k * k * k;
            }
            return 0.5 * ((k -= 2.0) * k * k + 2.0);
        }
    }

    public static class CubicOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            return (k -= 1.0) * k * k + 1.0;
        }
    }

    public static class CubicIn
    implements EasingFunction {
        @Override
        public double call(double k) {
            return k * k * k;
        }
    }

    public static class QuadraticInOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            double d;
            k *= 2.0;
            if (d < 1.0) {
                return 0.5 * k * k;
            }
            return -0.5 * ((k -= 1.0) * (k - 2.0) - 1.0);
        }
    }

    public static class QuadraticOut
    implements EasingFunction {
        @Override
        public double call(double k) {
            return k * (2.0 - k);
        }
    }

    public static class QuadraticIn
    implements EasingFunction {
        @Override
        public double call(double k) {
            return k * k;
        }
    }

    public static class Linear
    implements EasingFunction {
        @Override
        public double call(double k) {
            return k;
        }
    }

    public static interface EasingFunction {
        public double call(double var1);
    }
}

