/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.user;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import growthcraft.api.core.log.ILoggable;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.core.module.IModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;

public abstract class AbstractUserJSONConfig
implements ILoggable,
IModule {
    public static final String DEFAULT_ENCODING = "UTF-8";
    protected ILogger logger = NullLogger.INSTANCE;
    protected final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private File targetConfigFile;
    private File targetDefaultConfigFile;

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    protected abstract String getDefault();

    private void writeDefaultConfigTo(File file) {
        block16: {
            try {
                this.logger.debug("Creating default json-config %s", file);
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists() && !file.createNewFile()) {
                    this.logger.error("Could not create default config %s", file);
                    return;
                }
                if (!file.canWrite()) break block16;
                try (FileWriter writer = new FileWriter(file);){
                    writer.write(this.getDefault());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract void loadFromBuffer(BufferedReader var1) throws IllegalStateException;

    public AbstractUserJSONConfig setConfigFile(File dir, String filename) {
        this.targetConfigFile = new File(dir, filename);
        this.targetDefaultConfigFile = new File(dir, filename + ".default");
        this.logger.debug("Config file `%s` was set for `%s`", this.targetConfigFile, this);
        this.logger.debug("DEFAULT Config file `%s` was set for `%s`", this.targetDefaultConfigFile, this);
        return this;
    }

    private void prepareUserConfig() throws IOException {
        if (!this.targetConfigFile.exists()) {
            if (this.targetConfigFile.getParentFile() != null) {
                this.targetConfigFile.getParentFile().mkdirs();
            }
            if (!this.targetConfigFile.createNewFile()) {
                this.logger.error("Could not create config file `%s`", this.targetConfigFile);
                return;
            }
            if (this.targetDefaultConfigFile.exists()) {
                Files.copy((File)this.targetDefaultConfigFile, (File)this.targetConfigFile);
            } else {
                this.logger.error("Could not copy default config file `%s` to `%s`", this.targetDefaultConfigFile, this.targetConfigFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUserConfigFile(File file) {
        BufferedReader buffer = null;
        Configuration.UnicodeInputStreamReader input = null;
        try {
            this.logger.debug("Loading json-config %s", file);
            this.prepareUserConfig();
            if (file.canRead()) {
                input = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(file), DEFAULT_ENCODING);
                buffer = new BufferedReader((Reader)input);
                this.loadFromBuffer(buffer);
            } else {
                this.logger.error("Could not read config file %s", file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException iOException) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadUserConfig() {
        this.writeDefaultConfigTo(this.targetDefaultConfigFile);
        try {
            this.readUserConfigFile(this.targetConfigFile);
            return;
        }
        catch (Exception e) {
            this.logger.error("JSON Config '%s' contains errors", this.targetConfigFile);
            e.printStackTrace();
            this.logger.warn("Falling back to default config file", new Object[0]);
            this.readUserConfigFile(this.targetDefaultConfigFile);
            return;
        }
    }

    @Override
    public void preInit() {
    }

    @Override
    public void register() {
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }
}

