/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.item;

import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.item.ItemTest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreItemStacks
implements IMultiItemStacks {
    public int stackSize;
    private String oreName;

    public OreItemStacks(@Nonnull String name, int amount) {
        this.oreName = name;
        this.stackSize = amount;
    }

    public OreItemStacks(@Nonnull String name) {
        this(name, 1);
    }

    @Override
    public int getStackSize() {
        return this.stackSize;
    }

    public String getName() {
        return this.oreName;
    }

    public List<ItemStack> getRawItemStacks() {
        return OreDictionary.getOres((String)this.oreName);
    }

    @Override
    public boolean isEmpty() {
        return this.getRawItemStacks().isEmpty();
    }

    @Override
    public List<ItemStack> getItemStacks() {
        List<ItemStack> items = this.getRawItemStacks();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : items) {
            ItemStack newStack = stack.func_77946_l();
            if (newStack.field_77994_a <= 0) {
                newStack.field_77994_a = 1;
            }
            newStack.field_77994_a *= this.stackSize;
            result.add(newStack);
        }
        return result;
    }

    @Override
    public boolean containsItemStack(@Nullable ItemStack stack) {
        if (ItemTest.isValid(stack)) {
            int oreId = OreDictionary.getOreID((String)this.oreName);
            for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (i != oreId) continue;
                return true;
            }
        }
        return false;
    }
}

