/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.fluids;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidUtils {
    private static Map<Fluid, List<FluidContainerRegistry.FluidContainerData>> fluidData;

    private FluidUtils() {
    }

    public static Map<Fluid, List<FluidContainerRegistry.FluidContainerData>> getFluidData() {
        if (fluidData == null || fluidData.size() == 0) {
            fluidData = new HashMap<Fluid, List<FluidContainerRegistry.FluidContainerData>>();
            for (FluidContainerRegistry.FluidContainerData data : Arrays.asList(FluidContainerRegistry.getRegisteredFluidContainerData())) {
                if (!fluidData.containsKey(data.fluid.getFluid())) {
                    fluidData.put(data.fluid.getFluid(), new ArrayList());
                }
                fluidData.get(data.fluid.getFluid()).add(data);
            }
        }
        return fluidData;
    }

    public static List<ItemStack> getFluidContainers(FluidStack ... fluids) {
        if (fluids.length == 1) {
            ArrayList<ItemStack> fluidContainers = new ArrayList<ItemStack>();
            FluidStack fluidStack = fluids[0];
            for (FluidContainerRegistry.FluidContainerData data : FluidUtils.getFluidData().get(fluidStack.getFluid())) {
                if (data.fluid.amount < fluidStack.amount) continue;
                fluidContainers.add(data.filledContainer);
            }
            return fluidContainers;
        }
        return FluidUtils.getFluidContainers(Arrays.asList(fluids));
    }

    public static List<ItemStack> getFluidContainers(Collection<FluidStack> fluids) {
        ArrayList<ItemStack> fluidContainers = new ArrayList<ItemStack>();
        for (FluidStack fluidStack : fluids) {
            fluidContainers.addAll(FluidUtils.getFluidContainers(fluidStack));
        }
        return fluidContainers;
    }

    public static FluidStack drainFluidBlock(World world, int x, int y, int z, boolean doDrain) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockFluidBase) {
            BlockFluidBase bfb = (BlockFluidBase)block;
            return bfb.drain(world, x, y, z, doDrain);
        }
        if (block == Blocks.field_150353_l) {
            if (doDrain) {
                world.func_147468_f(x, y, z);
            }
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (block == Blocks.field_150355_j) {
            if (doDrain) {
                world.func_147468_f(x, y, z);
            }
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        return null;
    }

    public static List<Fluid> getFluidsByNames(List<String> names) {
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        for (String name : names) {
            fluids.add(FluidRegistry.getFluid((String)name));
        }
        return fluids;
    }

    public static FluidStack exchangeFluid(FluidStack stack, Fluid newFluid) {
        return new FluidStack(newFluid, stack.amount);
    }

    public static boolean doesFluidExist(String name) {
        return FluidRegistry.getFluid((String)name) != null && FluidRegistry.isFluidRegistered((String)name);
    }

    public static boolean doesFluidExist(Fluid fluid) {
        return fluid != null && FluidRegistry.isFluidRegistered((Fluid)fluid);
    }

    public static boolean doesFluidsExist(Fluid[] fluid) {
        for (int i = 0; i < fluid.length; ++i) {
            if (FluidUtils.doesFluidExist(fluid[i])) continue;
            return false;
        }
        return true;
    }

    public static FluidStack replaceFluidStack(int fluidId, FluidStack srcStack) {
        Fluid fluid = FluidRegistry.getFluid((int)fluidId);
        if (fluid == null) {
            return null;
        }
        if (srcStack == null) {
            return new FluidStack(fluid, 0);
        }
        return new FluidStack(fluid, srcStack.amount);
    }

    public static FluidStack updateFluidStackAmount(FluidStack srcStack, int amount) {
        if (srcStack == null) {
            return new FluidStack(FluidRegistry.WATER, amount);
        }
        srcStack.amount = amount;
        return srcStack;
    }
}

