/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.effect;

import growthcraft.api.core.description.Describer;
import growthcraft.api.core.effect.AbstractEffectList;
import growthcraft.api.core.effect.IEffect;
import growthcraft.api.core.i18n.GrcI18n;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class EffectRandomList
extends AbstractEffectList {
    public EffectRandomList copy() {
        return (EffectRandomList)new EffectRandomList().concat(this.effects);
    }

    @Override
    public void apply(World world, Entity entity, Random random, Object data) {
        int index = random.nextInt(this.effects.size());
        IEffect effect = (IEffect)this.effects.get(index);
        if (effect != null) {
            effect.apply(world, entity, random, data);
        }
    }

    @Override
    protected void getActualDescription(List<String> list) {
        if (this.effects.size() > 0) {
            ArrayList<String> tempList = new ArrayList<String>();
            list.add(GrcI18n.translate("grc.effect.random_list.head"));
            for (IEffect effect : this.effects) {
                tempList.clear();
                effect.getDescription(tempList);
                Describer.addAllIndented(list, tempList);
            }
        }
    }
}

