/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.yeast.user;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.yeast.user.UserYeastEntries;
import growthcraft.api.cellar.yeast.user.UserYeastEntry;
import growthcraft.api.core.schema.ItemKeySchema;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import growthcraft.api.core.util.BiomeUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;

public class UserYeastEntriesConfig
extends AbstractUserJSONConfig {
    private final UserYeastEntries defaultEntries = new UserYeastEntries();
    private UserYeastEntries entries;

    @Override
    protected String getDefault() {
        ItemKeySchema brewersYeast = new ItemKeySchema("Growthcraft|Cellar", "grc.yeast", 1, 0);
        brewersYeast.setComment("Brewers Yeast");
        ItemKeySchema lagerYeast = new ItemKeySchema("Growthcraft|Cellar", "grc.yeast", 1, 1);
        lagerYeast.setComment("Lager Yeast");
        ItemKeySchema etherealYeast = new ItemKeySchema("Growthcraft|Cellar", "grc.yeast", 1, 3);
        etherealYeast.setComment("Ethereal Yeast");
        ItemKeySchema originYeast = new ItemKeySchema("Growthcraft|Cellar", "grc.yeast", 1, 4);
        etherealYeast.setComment("Origin Yeast");
        UserYeastEntry brewers = new UserYeastEntry(brewersYeast, 1, new ArrayList<String>());
        brewers.setComment("Brewers yeast is the default yeast, which appears in all other biomes that are filled by the Lager or Ethereal");
        UserYeastEntry lager = new UserYeastEntry(lagerYeast, 10, new ArrayList<String>());
        lager.setComment("Lager yeast is found in COLD biomes, think snow places!");
        UserYeastEntry ethereal = new UserYeastEntry(etherealYeast, 10, new ArrayList<String>());
        ethereal.setComment("Ethereal yeast is found in MAGICAL biomes, because its special");
        UserYeastEntry origin = new UserYeastEntry(originYeast, 10, new ArrayList<String>());
        origin.setComment("Origin yeast is found in MUSHROOM biomes.");
        block5: for (BiomeDictionary.Type biomeType : BiomeDictionary.Type.values()) {
            String biomeTypeName = biomeType.name();
            switch (biomeType) {
                case COLD: {
                    lager.biome_types.add(biomeTypeName);
                    continue block5;
                }
                case MAGICAL: {
                    ethereal.biome_types.add(biomeTypeName);
                    continue block5;
                }
                case MUSHROOM: {
                    origin.biome_types.add(biomeTypeName);
                    continue block5;
                }
                default: {
                    brewers.biome_types.add(biomeTypeName);
                }
            }
        }
        this.defaultEntries.data.add(brewers);
        this.defaultEntries.data.add(ethereal);
        this.defaultEntries.data.add(lager);
        this.defaultEntries.data.add(origin);
        this.defaultEntries.setComment("Default Yeast Config v1.1.0");
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.entries = (UserYeastEntries)this.gson.fromJson((Reader)reader, UserYeastEntries.class);
    }

    private void addYeastEntry(UserYeastEntry entry) {
        if (entry == null) {
            this.logger.error("Yeast entry was invalid.", new Object[0]);
            return;
        }
        if (entry.item == null || entry.item.isInvalid()) {
            this.logger.error("Yeast item was invalid {%s}", entry);
            return;
        }
        for (ItemStack itemstack : entry.item.getItemStacks()) {
            if (entry.biome_types != null) {
                for (String biome : entry.biome_types) {
                    try {
                        BiomeDictionary.Type biomeType = BiomeUtils.fetchBiomeType(biome);
                        CellarRegistry.instance().yeast().addYeastToBiomeType(itemstack, entry.weight, biomeType);
                        this.logger.debug("Added user yeast {%s} to biome type '%s'", itemstack, biome);
                    }
                    catch (BiomeUtils.BiomeTypeNotFound ex) {
                        this.logger.error("A biome type '%s' for entry {%s} could not be found.", biome, entry);
                    }
                }
            }
            if (entry.biome_names == null) continue;
            for (String biomeName : entry.biome_names) {
                CellarRegistry.instance().yeast().addYeastToBiomeByName(itemstack, entry.weight, biomeName);
                this.logger.debug("Added user yeast {%s} to biome '%s'", itemstack, biomeName);
            }
        }
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                this.logger.debug("Adding %d yeast entries.", this.entries.data.size());
                for (UserYeastEntry entry : this.entries.data) {
                    this.addYeastEntry(entry);
                }
            } else {
                this.logger.error("Invalid yeast entries data", new Object[0]);
            }
        }
    }
}

