/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.heatsource;

import growthcraft.api.cellar.heatsource.GenericHeatSourceBlock;
import growthcraft.api.cellar.heatsource.IHeatSourceBlock;
import growthcraft.api.cellar.heatsource.IHeatSourceRegistry;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;

public class HeatSourceRegistry
implements IHeatSourceRegistry {
    public static final float DEFAULT_HEAT = 1.0f;
    public static final float NO_HEAT = 0.0f;
    private ILogger logger = NullLogger.INSTANCE;
    private HeatSourceTree heatSources = new HeatSourceTree();

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public void addHeatSource(@Nonnull Block block, int meta, IHeatSourceBlock heat) {
        if (!this.heatSources.containsKey(block)) {
            this.heatSources.put(block, new HeatMap());
        }
        HeatMap map = (HeatMap)this.heatSources.get(block);
        map.put(meta, heat);
        this.logger.debug("Added new HeatSource block=%s", block);
    }

    @Override
    public void addHeatSource(@Nonnull Block block, int meta, float heat) {
        this.addHeatSource(block, meta, new GenericHeatSourceBlock(block, heat));
    }

    @Override
    public void addHeatSource(@Nonnull Block block, int meta) {
        this.addHeatSource(block, meta, 1.0f);
    }

    @Override
    public void addHeatSource(@Nonnull Block block, IHeatSourceBlock heat) {
        this.addHeatSource(block, Short.MAX_VALUE, heat);
    }

    @Override
    public void addHeatSource(@Nonnull Block block) {
        this.addHeatSource(block, Short.MAX_VALUE);
    }

    @Override
    public IHeatSourceBlock getHeatSource(Block block, int meta) {
        HeatMap map = (HeatMap)this.heatSources.get(block);
        if (map == null) {
            return null;
        }
        IHeatSourceBlock f = (IHeatSourceBlock)map.get(meta);
        if (f == null) {
            f = (IHeatSourceBlock)map.get(Short.MAX_VALUE);
        }
        if (f == null) {
            return null;
        }
        return f;
    }

    @Override
    public IHeatSourceBlock getHeatSource(Block block) {
        return this.getHeatSource(block, Short.MAX_VALUE);
    }

    @Override
    public boolean isBlockHeatSource(Block block, int meta) {
        HeatMap map = (HeatMap)this.heatSources.get(block);
        if (map == null) {
            return false;
        }
        return map.get(meta) != null || map.get(Short.MAX_VALUE) != null;
    }

    @Override
    public boolean isBlockHeatSource(Block block) {
        return this.isBlockHeatSource(block, Short.MAX_VALUE);
    }

    static class HeatSourceTree
    extends HashMap<Block, HeatMap> {
        public static final long serialVersionUID = 1L;

        HeatSourceTree() {
        }
    }

    static class HeatMap
    extends HashMap<Integer, IHeatSourceBlock> {
        public static final long serialVersionUID = 1L;

        HeatMap() {
        }
    }
}

