/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.fermenting;

import growthcraft.api.cellar.fermenting.FermentationRecipe;
import growthcraft.api.cellar.fermenting.IFermentationRecipe;
import growthcraft.api.cellar.fermenting.IFermentingRegistry;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.core.util.MultiStacksUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FermentingRegistry
implements IFermentingRegistry {
    private List<IFermentationRecipe> recipes = new ArrayList<IFermentationRecipe>();
    private ILogger logger = NullLogger.INSTANCE;

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    private void onRecipeAdded(@Nonnull IFermentationRecipe recipe) {
        this.logger.debug("Added Fermentation recipe={%s}", recipe);
    }

    @Override
    public void addRecipe(@Nonnull IFermentationRecipe recipe) {
        this.recipes.add(recipe);
        this.onRecipeAdded(recipe);
    }

    @Override
    public void addRecipe(@Nonnull FluidStack result, @Nonnull Object booze, @Nonnull Object fermenter, int time) {
        this.addRecipe(new FermentationRecipe(MultiStacksUtil.toMultiFluidStacks(booze), MultiStacksUtil.toMultiItemStacks(fermenter), result, time));
    }

    @Override
    public IFermentationRecipe findRecipe(@Nullable FluidStack booze, @Nullable ItemStack fermenter) {
        if (booze == null || fermenter == null) {
            return null;
        }
        for (IFermentationRecipe recipe : this.recipes) {
            if (!recipe.matchesRecipe(booze, fermenter)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public List<IFermentationRecipe> findRecipes(@Nullable FluidStack fluid) {
        ArrayList<IFermentationRecipe> result = new ArrayList<IFermentationRecipe>();
        if (fluid != null) {
            for (IFermentationRecipe recipe : this.recipes) {
                if (!recipe.matchesIngredient(fluid)) continue;
                result.add(recipe);
            }
        }
        return result;
    }

    @Override
    public List<IFermentationRecipe> findRecipes(@Nullable ItemStack fermenter) {
        ArrayList<IFermentationRecipe> result = new ArrayList<IFermentationRecipe>();
        if (fermenter != null) {
            for (IFermentationRecipe recipe : this.recipes) {
                if (!recipe.matchesIngredient(fermenter)) continue;
                result.add(recipe);
            }
        }
        return result;
    }

    @Override
    public boolean canFerment(@Nullable FluidStack fluid) {
        ArrayList result = new ArrayList();
        if (fluid != null) {
            for (IFermentationRecipe recipe : this.recipes) {
                if (!recipe.matchesIngredient(fluid)) continue;
                return true;
            }
        }
        return false;
    }
}

