/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.part;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerOreDictExport;
import extracells.gui.GuiOreDictExport;
import extracells.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class PacketOreDictExport
extends AbstractPacket {
    private String filter;
    private Side side;

    public PacketOreDictExport() {
    }

    public PacketOreDictExport(EntityPlayer _player, String filter, Side side) {
        super(_player);
        this.mode = 0;
        this.filter = filter;
        this.side = side;
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                if (this.side.isClient()) {
                    try {
                        this.handleClient();
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                this.handleServer();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleClient() {
        GuiOreDictExport.updateFilter(this.filter);
    }

    private void handleServer() {
        Container con = this.player.field_71070_bA;
        if (con != null && con instanceof ContainerOreDictExport) {
            ContainerOreDictExport c = (ContainerOreDictExport)con;
            c.part.filter = this.filter;
        }
    }

    @Override
    public void readData(ByteBuf in) {
        switch (this.mode) {
            case 0: {
                this.side = in.readBoolean() ? Side.SERVER : Side.CLIENT;
                this.filter = ByteBufUtils.readUTF8String((ByteBuf)in);
            }
        }
    }

    @Override
    public void writeData(ByteBuf out) {
        switch (this.mode) {
            case 0: {
                out.writeBoolean(this.side.isServer());
                ByteBufUtils.writeUTF8String((ByteBuf)out, (String)this.filter);
            }
        }
    }
}

