/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.waila;

import extracells.tileentity.TileEntityCertusTank;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileCertusTankWailaDataProvider
implements IWailaDataProvider {
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        if (tile instanceof TileEntityCertusTank) {
            if (((TileEntityCertusTank)tile).tank.getFluid() == null) {
                tag.func_74768_a("fluidID", -1);
            } else {
                tag.func_74768_a("fluidID", ((TileEntityCertusTank)tile).tank.getFluid().getFluidID());
                tag.func_74768_a("currentFluid", ((TileEntityCertusTank)tile).tank.getFluidAmount());
            }
            tag.func_74768_a("maxFluid", ((TileEntityCertusTank)tile).tank.getCapacity());
        }
        return tag;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag == null) {
            return list;
        }
        if (tag.func_74764_b("fluidID")) {
            int fluidID = tag.func_74762_e("fluidID");
            if (fluidID == -1) {
                list.add(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + StatCollector.func_74838_a((String)"extracells.tooltip.empty1"));
                list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": 0mB / " + tag.func_74762_e("maxFluid") + "mB");
                return list;
            }
        } else {
            return list;
        }
        Fluid fluid = FluidRegistry.getFluid((int)tag.func_74762_e("fluidID"));
        list.add(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + fluid.getLocalizedName(new FluidStack(fluid, 1000)));
        if (tag.func_74764_b("maxFluid") && tag.func_74764_b("currentFluid")) {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": " + tag.func_74762_e("currentFluid") + "mB / " + tag.func_74762_e("maxFluid") + "mB");
        }
        return list;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

