/*
 * Decompiled with CFR 0.152.
 */
package singulariteam.eternalsingularity.proxy;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import fox.spiteful.avaritia.Config;
import fox.spiteful.avaritia.crafting.ExtremeCraftingManager;
import fox.spiteful.avaritia.crafting.Grinder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import singulariteam.eternalsingularity.EternalRecipeTweaker;
import singulariteam.eternalsingularity.EternalSingularityMod;
import singulariteam.eternalsingularity.item.CompoundSingularityItem;
import singulariteam.eternalsingularity.item.EternalSingularityItem;

public class CommonProxy {
    private static ShapelessOreRecipe eternalSingularityRecipe = null;
    private static final Set<Class> classSet = new HashSet<Class>();
    protected CompoundSingularityItem compoundSingularityItem = null;
    private File configFile;

    public final void preInit(File file) {
        this.configFile = file;
        Configuration config = new Configuration(this.configFile);
        String[] classNameList = config.getStringList("classNameList", "general", new String[]{"com.rcx.aobdsingularities.item.AOBDItemSingularity", "fox.spiteful.avaritia.items.ItemSingularity", "wanion.thermsingul.ThermalSingularityItem", "wealthyturtle.uiesingularities.UniversalSingularityItem"}, "here is the absolute class name of the Item Classes that must be removed from Infinity Catalyst recipe and inserted into Eternal Singularity.");
        if (config.hasChanged()) {
            config.save();
        }
        for (String className : classNameList) {
            try {
                classSet.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                EternalSingularityMod.logger.warn("Couldn't find " + className);
            }
        }
        GameRegistry.registerItem((Item)EternalSingularityItem.instance, (String)"eternal_singularity");
        if (Loader.isModLoaded((String)"MineTweaker3")) {
            EternalRecipeTweaker.init();
        }
    }

    public void init() {
    }

    @Nonnull
    public static ShapelessOreRecipe getEternalSingularityRecipe() {
        return eternalSingularityRecipe;
    }

    public void postInit() {
        if (classSet.isEmpty() || Config.craftingOnly) {
            return;
        }
        ArrayList<ItemStack> singularities = new ArrayList<ItemStack>();
        Iterator catalystRecipeIterator = Grinder.catalyst.getInput().iterator();
        while (catalystRecipeIterator.hasNext()) {
            Item item;
            Object input = catalystRecipeIterator.next();
            if (!(input instanceof ItemStack) || (item = ((ItemStack)input).func_77973_b()) == null || !classSet.contains(item.getClass())) continue;
            catalystRecipeIterator.remove();
            singularities.add(((ItemStack)input).func_77946_l());
        }
        Configuration config = new Configuration(this.configFile);
        int singularityCount = singularities.size();
        boolean aboveTheLimit = singularityCount > 81;
        boolean useCompoundSingularities = config.getBoolean("useCompoundSingularities", "general", aboveTheLimit, "When useCompoundSingularities is Enabled, Basic Singularities will Need to be Crafted into Compound Singularities First.\n[If there are > 81 Basic Singularities, this Config Option will be Set to True Automatically]") || aboveTheLimit;
        boolean easyMode = config.getBoolean("easyMode", "general", false, "If this Config Option is Enabled, for Every 9 Singularities Used in the Eternal Singularity Recipe, You will Receive an Additional Eternal Singularity for the Recipe Output.");
        if (config.hasChanged()) {
            config.save();
        }
        int compoundMax = (int)Math.ceil((float)singularityCount / 9.0f);
        eternalSingularityRecipe = new ShapelessOreRecipe(new ItemStack((Item)EternalSingularityItem.instance, easyMode ? MathHelper.func_76125_a((int)compoundMax, (int)1, (int)64) : 1), new Object[0]);
        eternalSingularityRecipe.getInput().addAll(singularities);
        if (useCompoundSingularities) {
            int i;
            this.compoundSingularityItem = new CompoundSingularityItem(compoundMax);
            GameRegistry.registerItem((Item)this.compoundSingularityItem, (String)"combined_singularity");
            ArrayList eternalSingularityRecipeInputs = eternalSingularityRecipe.getInput();
            for (i = 0; i < compoundMax; ++i) {
                int pos;
                ShapelessOreRecipe compoundRecipe = new ShapelessOreRecipe(new ItemStack((Item)this.compoundSingularityItem, 1, MathHelper.func_76125_a((int)i, (int)0, (int)64)), new Object[0]);
                for (int s = 0; s < 9 && (pos = 9 * i + s) <= singularityCount - 1; ++s) {
                    Object input = eternalSingularityRecipeInputs.get(pos);
                    if (!(input instanceof ItemStack)) continue;
                    compoundRecipe.getInput().add(((ItemStack)input).func_77946_l());
                }
                if (compoundRecipe.getInput().size() <= 0) continue;
                GameRegistry.addRecipe((IRecipe)compoundRecipe);
            }
            eternalSingularityRecipeInputs.clear();
            for (i = 0; i < compoundMax; ++i) {
                eternalSingularityRecipeInputs.add(new ItemStack((Item)this.compoundSingularityItem, 1, i));
            }
        }
        ExtremeCraftingManager.getInstance().getRecipeList().add(eternalSingularityRecipe);
        Grinder.catalyst.getInput().add(new ItemStack((Item)EternalSingularityItem.instance));
    }
}

