/*
 * Decompiled with CFR 0.152.
 */
package me.guichaguri.betterfps.transformers;

import java.util.Iterator;
import me.guichaguri.betterfps.tweaker.Naming;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EventTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return new byte[0];
        }
        try {
            if (Naming.C_Minecraft.is(name)) {
                return this.patchStart(bytes);
            }
            if (Naming.C_KeyBinding.is(name)) {
                return this.patchKeyTick(bytes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    private byte[] patchStart(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 4);
        Iterator methods = classNode.methods.iterator();
        boolean patch = false;
        while (methods.hasNext()) {
            MethodNode method = (MethodNode)methods.next();
            if (!Naming.M_startGame.is(method.name, method.desc)) continue;
            LogManager.getLogger().info("Patching Game Start...");
            InsnList list = new InsnList();
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (node.getOpcode() == 177) {
                    list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "me/guichaguri/betterfps/BetterFps", "start", "(L" + classNode.name + ";)V", false));
                }
                list.add(node);
            }
            method.instructions.clear();
            method.instructions.add(list);
            patch = true;
        }
        if (!patch) {
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchKeyTick(byte[] bytes) throws Exception {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 4);
        Iterator methods = classNode.methods.iterator();
        boolean patch = false;
        while (methods.hasNext()) {
            MethodNode method = (MethodNode)methods.next();
            if (!Naming.M_onTick.is(method.name, method.desc)) continue;
            LogManager.getLogger().info("Patching Key Event...");
            InsnList list = new InsnList();
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (node.getOpcode() == 177) {
                    list.add((AbstractInsnNode)new VarInsnNode(21, 0));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "me/guichaguri/betterfps/BetterFps", "keyEvent", "(I)V", false));
                }
                list.add(node);
            }
            method.instructions.clear();
            method.instructions.add(list);
            patch = true;
        }
        if (!patch) {
            return bytes;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

