/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.repackage.makamys.mclib.ext.assetdirector;

import DelirusCrux.Netherlicious.repackage.makamys.mclib.ext.assetdirector.AssetDirector;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;

public class URLMassager {
    private Set<String> checkedHosts = new HashSet<String>();
    private Set<String> httpHosts = new HashSet<String>();

    public URL toURL(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        if (url.getProtocol().toLowerCase().equals("https") && this.useHTTPForURL(url)) {
            return new URL("http", url.getHost(), url.getPort(), url.getFile());
        }
        return url;
    }

    private boolean useHTTPForURL(URL url) {
        String host = url.getHost();
        if (this.checkedHosts.contains(host)) {
            return this.httpHosts.contains(host);
        }
        this.checkedHosts.add(host);
        try {
            InputStream is = url.openStream();
            Throwable throwable = null;
            if (is != null) {
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    is.close();
                }
            }
        }
        catch (SSLHandshakeException e) {
            AssetDirector.LOGGER.warn("SSL handshake failed for host " + host + " (" + e.getMessage() + "). Will attempt to use HTTP for this host. This is a workaround for old Java versions not supporting new TLS ciphers - please try updating your Java to fix this issue if possible.");
            URLMassager.silentlyPrintStackTrace(e);
            this.httpHosts.add(host);
            return true;
        }
        catch (IOException e) {
            AssetDirector.LOGGER.warn("Failed to connect to host " + host + ".");
            e.printStackTrace();
        }
        return false;
    }

    private static void silentlyPrintStackTrace(Exception e) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        e.printStackTrace(out);
        AssetDirector.LOGGER.trace(writer.toString());
    }
}

