/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.World.Worldgen;

import DelirusCrux.Netherlicious.Common.BlockItemUtility.ModBlocks;
import DelirusCrux.Netherlicious.Utility.Configuration.WorldgenConfiguration;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.MinecraftForge;

public class WorldgenNetherMineable
implements IWorldGenerator {
    private final List<WorldGenMinable> generators = new LinkedList<WorldGenMinable>();
    private static final WorldgenNetherMineable INSTANCE = new WorldgenNetherMineable();

    public static void register() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)INSTANCE);
        GameRegistry.registerWorldGenerator((IWorldGenerator)INSTANCE, (int)0);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == -1) {
            if (WorldgenConfiguration.Magma) {
                this.generateMagmaForChunk(world, random, chunkX * 16, chunkZ * 16);
            }
            this.generateBlackstoneForChunk(world, random, chunkX * 16, chunkZ * 16);
            if (WorldgenConfiguration.Gold) {
                this.generateGoldOreForChunk(world, random, chunkX * 16, chunkZ * 16);
            }
            if (WorldgenConfiguration.Gold && WorldgenConfiguration.BigNether) {
                this.generateBigGoldOreForChunk(world, random, chunkX * 16, chunkZ * 16);
            }
            if (WorldgenConfiguration.Iron) {
                this.generateIronOreForChunk(world, random, chunkX * 16, chunkZ * 16);
            }
            if (WorldgenConfiguration.Iron && WorldgenConfiguration.BigNether) {
                this.generateBigIronOreForChunk(world, random, chunkX * 16, chunkZ * 16);
            }
            if (WorldgenConfiguration.Efrine) {
                this.generateEfrineOreForChunk(world, random, chunkX * 16, chunkZ * 16);
            }
            if (WorldgenConfiguration.Efrine && WorldgenConfiguration.BigNether) {
                this.generateBigEfrineOreForChunk(world, random, chunkX * 16, chunkZ * 16);
            }
            if (WorldgenConfiguration.NetherVoidQuartz) {
                this.generateVoidQuartzOreForChunk(world, random, chunkX * 16, chunkZ * 16);
            }
            if (WorldgenConfiguration.NetherVoidQuartz && WorldgenConfiguration.BigNether) {
                this.generateBigVoidQuartzOreForChunk(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    public void generateMagmaForChunk(World world, Random random, int x, int z) {
        for (int i = 0; i < 2; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosY = 27 + random.nextInt(10);
            int randPosZ = z + random.nextInt(16);
            new WorldGenMinable(ModBlocks.MagmaBlock, 1, 33, Blocks.field_150424_aL).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateBlackstoneForChunk(World world, Random random, int x, int z) {
        for (int i = 0; i < 2; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosY = 5 + random.nextInt(23);
            int randPosZ = z + random.nextInt(16);
            new WorldGenMinable(ModBlocks.Blackstone, 0, 33, Blocks.field_150424_aL).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateGoldOreForChunk(World world, Random random, int x, int z) {
        for (int i = 0; i < 10; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosY = 10 + random.nextInt(107);
            int randPosZ = z + random.nextInt(16);
            new WorldGenMinable(ModBlocks.NetherGoldOre, 0, 1 + random.nextInt(9), Blocks.field_150424_aL).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateBigGoldOreForChunk(World world, Random random, int x, int z) {
        for (int i = 0; i < 10; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosY = 117 + random.nextInt(133);
            int randPosZ = z + random.nextInt(16);
            new WorldGenMinable(ModBlocks.NetherGoldOre, 0, 1 + random.nextInt(9), Blocks.field_150424_aL).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateIronOreForChunk(World world, Random random, int x, int z) {
        for (int i = 0; i < 10; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosY = 10 + random.nextInt(107);
            int randPosZ = z + random.nextInt(16);
            new WorldGenMinable(ModBlocks.NetherIronOre, 0, 1 + random.nextInt(9), Blocks.field_150424_aL).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateBigIronOreForChunk(World world, Random random, int x, int z) {
        for (int i = 0; i < 10; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosY = 117 + random.nextInt(133);
            int randPosZ = z + random.nextInt(16);
            new WorldGenMinable(ModBlocks.NetherIronOre, 0, 1 + random.nextInt(9), Blocks.field_150424_aL).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateEfrineOreForChunk(World world, Random random, int x, int z) {
        for (int i = 0; i < 10; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosY = 10 + random.nextInt(107);
            int randPosZ = z + random.nextInt(16);
            new WorldGenMinable(ModBlocks.EfrineOre, 0, 1 + random.nextInt(9), Blocks.field_150424_aL).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateBigEfrineOreForChunk(World world, Random random, int x, int z) {
        for (int i = 0; i < 10; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosY = 117 + random.nextInt(133);
            int randPosZ = z + random.nextInt(16);
            new WorldGenMinable(ModBlocks.EfrineOre, 0, 1 + random.nextInt(9), Blocks.field_150424_aL).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateVoidQuartzOreForChunk(World world, Random random, int x, int z) {
        for (int i = 0; i < 10; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosY = 10 + random.nextInt(108);
            int randPosZ = z + random.nextInt(16);
            new WorldGenMinable(ModBlocks.VoidQuartzOre, 1, 13, Blocks.field_150424_aL).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateBigVoidQuartzOreForChunk(World world, Random random, int x, int z) {
        for (int i = 0; i < 10; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosY = 118 + random.nextInt(126);
            int randPosZ = z + random.nextInt(16);
            new WorldGenMinable(ModBlocks.VoidQuartzOre, 1, 13, Blocks.field_150424_aL).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }
}

