/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.World.Features.Trees.Bubbling;

import DelirusCrux.Netherlicious.Common.BlockItemUtility.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FragrantTree
extends WorldGenerator {
    private Block log;
    private Block leaves;
    private int logmeta;
    private int leavesmeta;
    private int lightmeta;

    protected boolean isReplaceable(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.isAir((IBlockAccess)world, x, y, z);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(3) + 7;
        int maxRadius = 3;
        Block block2 = world.func_147439_a(x, y - 1, z);
        this.log = ModBlocks.FungiLogs2;
        this.leaves = ModBlocks.WartBlock;
        this.logmeta = 2;
        this.leavesmeta = 4;
        this.lightmeta = 1;
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_147437_c(xx, yy, zz)) continue;
                    return false;
                }
            }
        }
        if (!this.isReplaceable(world, x, y, z)) {
            return false;
        }
        if (block2 != ModBlocks.BubblingNylium) {
            return false;
        }
        for (int yy = y; yy < y + height; ++yy) {
            if (world.func_147439_a(x, yy, z).isAir((IBlockAccess)world, x, yy, z)) {
                world.func_147465_d(x, yy, z, this.log, this.logmeta, 2);
            }
            if (yy == y + height - 1) {
                this.createLeaves(world, rand, x, yy, z, true);
            }
            if (yy != y + height - 4) continue;
            this.createlBranch(world, rand, x + 1, yy - rand.nextInt(2), z, 1, 1 + rand.nextInt(2));
            this.createlBranch(world, rand, x - 1, yy - rand.nextInt(2), z, 2, 1 + rand.nextInt(2));
            this.createlBranch(world, rand, x, yy - rand.nextInt(2), z + 1, 3, 1 + rand.nextInt(2));
            this.createlBranch(world, rand, x, yy - rand.nextInt(2), z - 1, 4, 1 + rand.nextInt(2));
        }
        return true;
    }

    private void createlBranch(World world, Random rand, int x, int y, int z, int dir, int branchLength) {
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 1) {
                ++y;
                meta = 0;
            }
            if (dir == 1) {
                world.func_147465_d(x + i, y, z, this.log, this.logmeta, 2);
                if (i == branchLength) {
                    this.createLeaves(world, rand, x + i, y, z, false);
                }
            }
            if (dir == 2) {
                world.func_147465_d(x - i, y, z, this.log, this.logmeta, 2);
                if (i == branchLength) {
                    this.createLeaves(world, rand, x - i, y, z, false);
                }
            }
            if (dir == 3) {
                world.func_147465_d(x, y, z + i, this.log, this.logmeta, 2);
                if (i == branchLength) {
                    this.createLeaves(world, rand, x, y, z + i, false);
                }
            }
            if (dir == 4) {
                world.func_147465_d(x, y, z - i, this.log, this.logmeta, 2);
                if (i == branchLength) {
                    this.createLeaves(world, rand, x, y, z - i, false);
                }
            }
            if (dir == 5) {
                world.func_147465_d(x + i - 1, y, z + i - 1, this.log, this.logmeta, 2);
                if (i == branchLength) {
                    this.createLeaves(world, rand, x + i - 1, y, z + i - 1, false);
                }
            }
            if (dir == 6) {
                world.func_147465_d(x - i + 1, y, z - i + 1, this.log, this.logmeta, 2);
                if (i == branchLength) {
                    this.createLeaves(world, rand, x - i + 1, y, z - i + 1, false);
                }
            }
            if (dir == 7) {
                world.func_147465_d(x - i + 1, y, z + i - 1, this.log, this.logmeta, 2);
                if (i == branchLength) {
                    this.createLeaves(world, rand, x - i + 1, y, z + i - 1, false);
                }
            }
            if (dir != 8) continue;
            world.func_147465_d(x + i - 1, y, z - i + 1, this.log, this.logmeta, 2);
            if (i != branchLength) continue;
            this.createLeaves(world, rand, x + i - 1, y, z - i + 1, false);
        }
    }

    private void placeRandomBlock(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z)) {
            if (random.nextInt(20) == 0) {
                this.func_150516_a(world, x, y, z, ModBlocks.ShroomLight, this.lightmeta);
            } else {
                this.func_150516_a(world, x, y, z, this.leaves, this.leavesmeta);
            }
        }
    }

    private void createLeaves(World world, Random random, int x, int y, int z, boolean top) {
        this.placeRandomBlock(world, random, x, y, z + 1);
        this.placeRandomBlock(world, random, x, y, z - 1);
        this.placeRandomBlock(world, random, x + 1, y, z);
        this.placeRandomBlock(world, random, x - 1, y, z);
        if (top) {
            this.placeRandomBlock(world, random, x, y + 1, z);
            this.placeRandomBlock(world, random, x, y - 1, z + 1);
            this.placeRandomBlock(world, random, x, y - 1, z - 1);
            this.placeRandomBlock(world, random, x + 1, y - 1, z);
            this.placeRandomBlock(world, random, x - 1, y - 1, z);
        } else {
            this.placeRandomBlock(world, random, x, y + 1, z);
            this.placeRandomBlock(world, random, x, y - 1, z);
        }
    }

    private void createRoots(World world, int x, int y, int z) {
        world.func_147465_d(x, y, z + 1, this.log, this.logmeta, 2);
        world.func_147465_d(x, y, z - 1, this.log, this.logmeta, 2);
        world.func_147465_d(x + 1, y, z, this.log, this.logmeta, 2);
        world.func_147465_d(x - 1, y, z, this.log, this.logmeta, 2);
    }
}

