/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.api.data.OreDictToReactantMapping;
import erogenousbeef.bigreactors.api.data.SourceProductMapping;
import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.client.gui.GuiReactorAccessPort;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.data.StandardReactants;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.gui.container.ContainerReactorAccessPort;
import erogenousbeef.bigreactors.utils.AdjacentInventoryHelper;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityReactorAccessPort
extends TileEntityReactorPart
implements IInventory,
ISidedInventory,
INeighborUpdatableEntity {
    protected ItemStack[] _inventories = new ItemStack[this.func_70302_i_()];
    protected boolean isInlet = true;
    protected AdjacentInventoryHelper adjacencyHelper;
    public static final int SLOT_INLET = 0;
    public static final int SLOT_OUTLET = 1;
    public static final int NUM_SLOTS = 2;
    private static final int[] kInletExposed = new int[]{0};
    private static final int[] kOutletExposed = new int[]{1};

    public String getInputReactantType() {
        ItemStack inputItem = this.func_70301_a(0);
        if (inputItem == null) {
            return null;
        }
        OreDictToReactantMapping mapping = Reactants.getSolidToReactant(inputItem);
        return mapping != null ? mapping.getProduct() : null;
    }

    public int getInputReactantAmount() {
        ItemStack inputItem = this.func_70301_a(0);
        if (inputItem == null) {
            return 0;
        }
        OreDictToReactantMapping mapping = Reactants.getSolidToReactant(inputItem);
        return mapping != null ? mapping.getProductAmount(inputItem.field_77994_a) : 0;
    }

    public int consumeReactantItem(int reactantDesired) {
        ItemStack inputItem = this.func_70301_a(0);
        if (inputItem == null) {
            return 0;
        }
        OreDictToReactantMapping mapping = Reactants.getSolidToReactant(inputItem);
        if (mapping == null) {
            return 0;
        }
        int sourceItemsToConsume = Math.min(inputItem.field_77994_a, mapping.getSourceAmount(reactantDesired));
        if (sourceItemsToConsume <= 0) {
            return 0;
        }
        this.func_70298_a(0, sourceItemsToConsume);
        return mapping.getProductAmount(sourceItemsToConsume);
    }

    public int emitReactant(String reactantType, int amount) {
        int itemsToProduce;
        if (reactantType == null || amount <= 0) {
            return 0;
        }
        ItemStack outputItem = this.func_70301_a(1);
        if (outputItem != null && outputItem.field_77994_a >= this.func_70297_j_()) {
            return 0;
        }
        if (outputItem != null) {
            OreDictToReactantMapping mapping = Reactants.getSolidToReactant(outputItem);
            if (mapping == null || !reactantType.equals(mapping.getProduct())) {
                return 0;
            }
            int amtToProduce = mapping.getSourceAmount(amount);
            if ((amtToProduce = Math.min(amtToProduce, this.func_70297_j_() - outputItem.field_77994_a)) <= 0) {
                return 0;
            }
            int reactantToConsume = mapping.getProductAmount(amtToProduce);
            if (reactantToConsume <= 0) {
                return 0;
            }
            outputItem.field_77994_a += amtToProduce;
            this.onItemsReceived();
            return reactantToConsume;
        }
        SourceProductMapping bestMapping = null;
        List<SourceProductMapping> mappings = Reactants.getReactantToSolids(reactantType);
        if (mappings != null) {
            int bestReactantAmount = 0;
            for (SourceProductMapping mapping : mappings) {
                int potentialProducts = mapping.getProductAmount(amount);
                int potentialReactant = mapping.getSourceAmount(potentialProducts);
                if (bestMapping != null && bestReactantAmount >= potentialReactant) continue;
                bestMapping = mapping;
                bestReactantAmount = potentialReactant;
            }
        }
        if (bestMapping == null) {
            BRLog.warning("There are no mapped item types for reactant %s. Using cyanite instead.", reactantType);
            bestMapping = StandardReactants.cyaniteMapping;
        }
        if ((itemsToProduce = Math.min(bestMapping.getProductAmount(amount), this.func_70297_j_())) <= 0) {
            return 0;
        }
        int reactantConsumed = bestMapping.getSourceAmount(itemsToProduce);
        itemsToProduce = bestMapping.getProductAmount(reactantConsumed);
        ItemStack newItem = ItemHelper.getOre((String)bestMapping.getProduct());
        if (newItem == null) {
            BRLog.warning("Could not find item for oredict entry %s, using cyanite instead.", bestMapping.getSource());
            newItem = BigReactors.ingotGeneric.getItemStackForType("ingotCyanite");
        } else {
            newItem = newItem.func_77946_l();
        }
        newItem.field_77994_a = itemsToProduce;
        this.func_70299_a(1, newItem);
        this.onItemsReceived();
        return reactantConsumed;
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        this.adjacencyHelper = new AdjacentInventoryHelper(this.getOutwardsDir());
        this.checkForAdjacentInventories();
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        this.adjacencyHelper = null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this._inventories = new ItemStack[this.func_70302_i_()];
        if (tag.func_74764_b("Items")) {
            NBTTagList tagList = tag.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = tagList.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot > this._inventories.length) continue;
                ItemStack itemStack = new ItemStack((Block)null, 0, 0);
                itemStack.func_77963_c(itemTag);
                this._inventories[slot] = itemStack;
            }
        }
        if (tag.func_74764_b("isInlet")) {
            this.isInlet = tag.func_74767_n("isInlet");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this._inventories.length; ++i) {
            if (this._inventories[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this._inventories[i].func_77955_b(itemTag);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        if (tagList.func_74745_c() > 0) {
            tag.func_74782_a("Items", (NBTBase)tagList);
        }
        tag.func_74757_a("isInlet", this.isInlet);
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("inlet", this.isInlet);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        if (packetData.func_74764_b("inlet")) {
            this.setInlet(packetData.func_74767_n("inlet"));
        }
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        return this._inventories[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this._inventories[slot] != null) {
            if (this._inventories[slot].field_77994_a <= amount) {
                ItemStack itemstack = this._inventories[slot];
                this._inventories[slot] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack newStack = this._inventories[slot].func_77979_a(amount);
            if (this._inventories[slot].field_77994_a == 0) {
                this._inventories[slot] = null;
            }
            this.func_70296_d();
            return newStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this._inventories[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "Access Port";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (itemstack == null) {
            return true;
        }
        if (slot == 0) {
            return Reactants.isFuel(itemstack);
        }
        if (slot == 1) {
            return Reactants.isWaste(itemstack);
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        if (this.isInlet()) {
            return kInletExposed;
        }
        return kOutletExposed;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    @Override
    public Object getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerReactorAccessPort(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiElement(InventoryPlayer inventoryPlayer) {
        return new GuiReactorAccessPort(new ContainerReactorAccessPort(this, inventoryPlayer), this);
    }

    public void onItemsReceived() {
        this.distributeItems();
        this.markChunkDirty();
    }

    public boolean isInlet() {
        return this.isInlet;
    }

    public void setInlet(boolean shouldBeInlet) {
        if (this.isInlet == shouldBeInlet) {
            return;
        }
        this.isInlet = shouldBeInlet;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.field_145850_b.field_72995_K) {
            this.distributeItems();
            this.markChunkDirty();
        }
        this.notifyNeighborsOfTileChange();
    }

    protected void distributeItems() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.adjacencyHelper == null) {
            return;
        }
        if (this.isInlet()) {
            return;
        }
        this._inventories[1] = this.adjacencyHelper.distribute(this._inventories[1]);
        this.markChunkDirty();
    }

    protected void checkForAdjacentInventories() {
        TileEntity te;
        ForgeDirection outDir = this.getOutwardsDir();
        if (this.adjacencyHelper == null && outDir != ForgeDirection.UNKNOWN) {
            this.adjacencyHelper = new AdjacentInventoryHelper(outDir);
        }
        if (this.adjacencyHelper != null && outDir != ForgeDirection.UNKNOWN && this.adjacencyHelper.set(te = this.field_145850_b.func_147438_o(this.field_145851_c + outDir.offsetX, this.field_145848_d + outDir.offsetY, this.field_145849_e + outDir.offsetZ))) {
            this.distributeItems();
        }
    }

    protected void markChunkDirty() {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborBlock) {
        this.checkForAdjacentInventories();
    }

    @Override
    public void onNeighborTileChange(IBlockAccess world, int x, int y, int z, int neighborX, int neighborY, int neighborZ) {
        int side = BlockHelper.determineAdjacentSide((TileEntity)this, (int)neighborX, (int)neighborY, (int)neighborZ);
        if (side == this.getOutwardsDir().ordinal()) {
            this.checkForAdjacentInventories();
        }
    }
}

