/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.helpers.FluidHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CoolantContainer
extends FluidHelper {
    public static final int HOT = 0;
    public static final int COLD = 1;
    private static final String[] tankNames = new String[]{"hot", "cold"};
    private int fluidVaporizedLastTick = 0;

    public CoolantContainer() {
        super(true);
    }

    @Override
    public int getNumberOfFluidTanks() {
        return 2;
    }

    @Override
    protected String[] getNBTTankNames() {
        return tankNames;
    }

    public boolean isAcceptedCoolant(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return fluid.getID() == FluidRegistry.WATER.getID();
    }

    public int addCoolant(FluidStack incoming) {
        if (incoming == null) {
            return 0;
        }
        return this.fill(1, incoming, true);
    }

    public int drainCoolant(int amount) {
        return this.drainFluidFromStack(1, amount);
    }

    public Fluid getCoolantType() {
        return this.getFluidType(1);
    }

    public int getCoolantAmount() {
        return this.getFluidAmount(1);
    }

    public Fluid getVaporType() {
        return this.getFluidType(0);
    }

    public int getVaporAmount() {
        return this.getFluidAmount(0);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound destination) {
        super.writeToNBT(destination);
        return destination;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
    }

    public void emptyCoolant() {
        this.setFluid(1, null);
    }

    public void emptyVapor() {
        this.setFluid(0, null);
    }

    public void setCoolant(FluidStack newFuel) {
        this.setFluid(1, newFuel);
    }

    public void setVapor(FluidStack newWaste) {
        this.setFluid(0, newWaste);
    }

    public void merge(CoolantContainer other) {
        super.merge(other);
    }

    public float getCoolantTemperature(float reactorTemperature) {
        Fluid coolantType = this.getCoolantType();
        if (coolantType == null || this.getFluidAmount(1) <= 0) {
            return reactorTemperature;
        }
        return Math.min(reactorTemperature, this.getBoilingPoint(coolantType));
    }

    public float onAbsorbHeat(float rfAbsorbed) {
        if (this.getFluidAmount(1) <= 0 || rfAbsorbed <= 0.0f) {
            return rfAbsorbed;
        }
        Fluid coolantType = this.getCoolantType();
        int coolantAmt = this.getFluidAmount(1);
        float heatOfVaporization = this.getHeatOfVaporization(coolantType);
        int mbVaporized = Math.min(coolantAmt, (int)(rfAbsorbed / heatOfVaporization));
        if ((mbVaporized = Math.min(mbVaporized, this.getRemainingSpaceForFluid(0))) < 1) {
            return rfAbsorbed;
        }
        Fluid newVaporType = this.getVaporizedCoolantFluid(coolantType);
        if (newVaporType == null) {
            BRLog.warning("Coolant in tank (%s) has no registered vapor type!", coolantType.getName());
            return rfAbsorbed;
        }
        Fluid existingVaporType = this.getVaporType();
        if (existingVaporType != null && !newVaporType.getName().equals(existingVaporType.getName())) {
            return rfAbsorbed;
        }
        this.fluidVaporizedLastTick = mbVaporized;
        this.drainCoolant(mbVaporized);
        if (existingVaporType != null) {
            this.addFluidToStack(0, mbVaporized);
        } else {
            this.fill(0, new FluidStack(newVaporType, mbVaporized), true);
        }
        float energyConsumed = (float)mbVaporized * heatOfVaporization;
        return Math.max(0.0f, rfAbsorbed - energyConsumed);
    }

    private float getBoilingPoint(Fluid fluid) {
        if (fluid == null) {
            throw new IllegalArgumentException("Cannot pass a null fluid to getBoilingPoint");
        }
        return 100.0f;
    }

    private float getHeatOfVaporization(Fluid fluid) {
        if (fluid == null) {
            throw new IllegalArgumentException("Cannot pass a null fluid to getHeatOfVaporization");
        }
        return 4.0f;
    }

    private Fluid getVaporizedCoolantFluid(Fluid fluid) {
        if (fluid == null) {
            throw new IllegalArgumentException("Cannot pass a null fluid to getVaporizedCoolantFluid");
        }
        return BigReactors.fluidSteam;
    }

    @Override
    protected boolean isFluidValidForStack(int stackIdx, Fluid fluid) {
        switch (stackIdx) {
            case 1: {
                return this.isAcceptedCoolant(fluid);
            }
            case 0: {
                return true;
            }
        }
        return false;
    }

    public int getFluidVaporizedLastTick() {
        return this.fluidVaporizedLastTick;
    }
}

