/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.skin.cape.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;

class TextureUtils {
    TextureUtils() {
    }

    @Nullable
    static BufferedImage getRightSkin(BufferedImage image) {
        if (image == null) {
            return null;
        }
        if (image.getWidth() % 64 == 0 && image.getHeight() % 32 == 0 && image.getHeight() == image.getWidth() / 2) {
            return image;
        }
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight() / 2, 6);
        for (int i = 0; i < temp.getWidth(); ++i) {
            for (int j = 0; j < temp.getHeight(); ++j) {
                temp.setRGB(i, j, image.getRGB(i, j));
            }
        }
        return temp;
    }

    static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }
}

