/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.skin.cape;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tlauncher.skin.cape.renderer.TextureManager;
import org.tlauncher.skin.cape.renderer.texture.FramedTexture;
import org.tlauncher.skin.cape.util.PreparedProfileManager;

@Mod(modid="tlauncher_custom_cape_skin", name="TLSkinCape", version="1.0")
public class TLSkinCape {
    static final String NAME = "TLSkinCape";
    static final String MODID = "tlauncher_custom_cape_skin";
    @Mod.Instance(value="tlauncher_custom_cape_skin")
    public static TLSkinCape instance;
    private static final Logger LOGGER;
    private TextureManager textureManager;
    private PreparedProfileManager preparedProfileManager;
    private static long lastTimeMills;

    @Mod.EventHandler
    public void event(FMLPostInitializationEvent event) {
        this.preparedProfileManager = new PreparedProfileManager();
        this.textureManager = new TextureManager();
        this.textureManager.setPreparedProfileManager(this.preparedProfileManager);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void event(RenderPlayerEvent.Specials.Pre event) {
        if (event.entityPlayer instanceof AbstractClientPlayer) {
            String name = event.entityPlayer.func_70005_c_();
            if (this.textureManager.isInit(name, MinecraftProfileTexture.Type.CAPE)) {
                FramedTexture framedTexture = this.textureManager.get(name).getCape();
                if (Objects.nonNull(framedTexture)) {
                    ((AbstractClientPlayer)event.entityPlayer).func_152121_a(MinecraftProfileTexture.Type.CAPE, framedTexture.getFrame());
                }
            } else {
                this.createTexture(name);
            }
            if (this.textureManager.isInit(name, MinecraftProfileTexture.Type.SKIN)) {
                ResourceLocation resourceLocation = this.textureManager.get(name).getSkin();
                if (Objects.nonNull(resourceLocation)) {
                    ((AbstractClientPlayer)event.entityPlayer).func_152121_a(MinecraftProfileTexture.Type.SKIN, resourceLocation);
                }
            } else {
                instance.createTexture(name);
            }
        }
    }

    @SubscribeEvent
    public void event(RenderHandEvent event) {
        String name = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        if (this.textureManager.isInit(name, MinecraftProfileTexture.Type.CAPE)) {
            FramedTexture framedTexture = this.textureManager.get(name).getCape();
            if (Objects.nonNull(framedTexture)) {
                Minecraft.func_71410_x().field_71439_g.func_152121_a(MinecraftProfileTexture.Type.CAPE, framedTexture.getFrame());
            }
        } else {
            this.createTexture(name);
        }
        if (this.textureManager.isInit(name, MinecraftProfileTexture.Type.SKIN)) {
            ResourceLocation resourceLocation = this.textureManager.get(name).getSkin();
            if (Objects.nonNull(resourceLocation)) {
                Minecraft.func_71410_x().field_71439_g.func_152121_a(MinecraftProfileTexture.Type.SKIN, resourceLocation);
            }
        } else {
            instance.createTexture(name);
        }
    }

    private void createTexture(String name) {
        if (System.currentTimeMillis() - lastTimeMills >= 90L) {
            this.preparedProfileManager.addNewName(name);
            this.textureManager.createFramedTextures();
            lastTimeMills = System.currentTimeMillis();
        }
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

