/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.network;

import com.slymask3.instantblocks.block.instant.BlockInstantTree;
import com.slymask3.instantblocks.network.AbstractPacket;
import com.slymask3.instantblocks.util.BuildHelper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketTree
extends AbstractPacket {
    int _dim;
    int _x;
    int _y;
    int _z;
    int _type;
    boolean _log;
    boolean _leaves;
    boolean _air;

    public PacketTree() {
    }

    public PacketTree(World world, int x, int y, int z, int type, boolean fullLogs, boolean fullLeaves, boolean air) {
        this._dim = world.field_73011_w.field_76574_g;
        this._x = x;
        this._y = y;
        this._z = z;
        this._type = type;
        this._log = fullLogs;
        this._leaves = fullLeaves;
        this._air = air;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this._dim);
        buffer.writeInt(this._x);
        buffer.writeInt(this._y);
        buffer.writeInt(this._z);
        buffer.writeInt(this._type);
        buffer.writeBoolean(this._log);
        buffer.writeBoolean(this._leaves);
        buffer.writeBoolean(this._air);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this._dim = buffer.readInt();
        this._x = buffer.readInt();
        this._y = buffer.readInt();
        this._z = buffer.readInt();
        this._type = buffer.readInt();
        this._log = buffer.readBoolean();
        this._leaves = buffer.readBoolean();
        this._air = buffer.readBoolean();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        WorldServer world = DimensionManager.getWorld((int)this._dim);
        BlockInstantTree block = (BlockInstantTree)BuildHelper.getBlock((World)world, this._x, this._y, this._z);
        block.build((World)world, this._x, this._y, this._z, this._type, this._log, this._leaves, this._air);
        block.afterBuild((World)world, this._x, this._y, this._z, player);
    }
}

