/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.network;

import com.slymask3.instantblocks.block.instant.BlockInstantSchematic;
import com.slymask3.instantblocks.network.AbstractPacket;
import com.slymask3.instantblocks.util.BuildHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketSchematic
extends AbstractPacket {
    int _dim;
    int _x;
    int _y;
    int _z;
    String _schematic;
    boolean _center;
    boolean _air;

    public PacketSchematic() {
    }

    public PacketSchematic(World world, int x, int y, int z, String schematic, boolean center, boolean air) {
        this._dim = world.field_73011_w.field_76574_g;
        this._x = x;
        this._y = y;
        this._z = z;
        this._schematic = schematic;
        this._center = center;
        this._air = air;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this._dim);
        buffer.writeInt(this._x);
        buffer.writeInt(this._y);
        buffer.writeInt(this._z);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this._schematic);
        buffer.writeBoolean(this._center);
        buffer.writeBoolean(this._air);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this._dim = buffer.readInt();
        this._x = buffer.readInt();
        this._y = buffer.readInt();
        this._z = buffer.readInt();
        this._schematic = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this._center = buffer.readBoolean();
        this._air = buffer.readBoolean();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        WorldServer world = DimensionManager.getWorld((int)this._dim);
        BlockInstantSchematic block = (BlockInstantSchematic)BuildHelper.getBlock((World)world, this._x, this._y, this._z);
        boolean built = block.build((World)world, this._x, this._y, this._z, this._schematic, this._center, this._air);
        if (built) {
            block.afterBuild((World)world, this._x, this._y, this._z, player);
        }
    }
}

