/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.gui.instant;

import com.slymask3.instantblocks.InstantBlocks;
import com.slymask3.instantblocks.block.BlockInstant;
import com.slymask3.instantblocks.gui.GuiInstant;
import com.slymask3.instantblocks.gui.module.GuiTreeSlot;
import com.slymask3.instantblocks.network.PacketTree;
import com.slymask3.instantblocks.tileentity.TileEntityTree;
import com.slymask3.instantblocks.util.BuildHelper;
import cpw.mods.fml.client.config.GuiCheckBox;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class GuiTree
extends GuiInstant {
    protected final TileEntityTree tileEntity;
    private GuiTreeSlot treeList;
    private int selected = -1;
    private int selectedTree;
    private int[] trees = new int[]{0, 1, 2, 3, 4, 5, 6};
    private GuiCheckBox fullLog;
    private GuiCheckBox fullLeaves;
    private GuiCheckBox air;

    public GuiTree(EntityPlayer player, TileEntityTree entity, World world, int x, int y, int z) {
        super(player, world, x, y, z);
        this.tileEntity = entity;
    }

    @Override
    public void init() {
        this.fullLog = new GuiCheckBox(this.getID(), this.field_146294_l / 2 + 4, 50, "Hollow Logs", true);
        this.field_146292_n.add(this.fullLog);
        this.fullLeaves = new GuiCheckBox(this.getID(), this.field_146294_l / 2 + 4, 60, "Hollow Leaves", true);
        this.field_146292_n.add(this.fullLeaves);
        this.air = new GuiCheckBox(this.getID(), this.field_146294_l / 2 + 4, 80, "Air Blocks Inside", true);
        this.field_146292_n.add(this.air);
        this.treeList = new GuiTreeSlot(this, this.trees, this.field_146294_l / 2 - 4 - 150, 50, 150, 120);
        this.treeList.registerScrollButtons(this.field_146292_n, 7, 8);
        this.done.field_146124_l = false;
    }

    @Override
    public void draw(int par1, int par2, float par3) {
        this.func_73732_a(this.field_146289_q, "Instant Huge Tree Block", this.field_146294_l / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Options:", this.field_146294_l / 2 + 4, 40, 0xA0A0A0);
        this.treeList.drawScreen(par1, par2, par3);
        GuiTree.func_73734_a((int)(this.field_146294_l / 2 - 4 - 150), (int)37, (int)(this.field_146294_l / 2 - 4 - 150 + 150), (int)50, (int)-16777216);
        GuiTree.func_73734_a((int)(this.field_146294_l / 2 - 4 - 150), (int)170, (int)(this.field_146294_l / 2 - 4 - 150 + 150), (int)183, (int)-16777216);
        this.func_73731_b(this.field_146289_q, "Tree Type:", this.field_146294_l / 2 - 2 - 150, 40, 0xA0A0A0);
    }

    @Override
    public void sendInfo() {
        InstantBlocks.packetPipeline.sendToServer(new PacketTree(this.world, this.x, this.y, this.z, this.selectedTree, !this.fullLog.isChecked(), !this.fullLeaves.isChecked(), this.air.isChecked()));
        BlockInstant block = (BlockInstant)BuildHelper.getBlock(this.world, this.x, this.y, this.z);
        block.setCreateMessage("Instant %tree% created.".replace("%tree%", this.treeToString(this.selectedTree)));
        block.afterBuild(this.world, this.x, this.y, this.z, this.player);
    }

    private String treeToString(int tree) {
        switch (tree) {
            case 0: {
                return "Huge Oak Tree";
            }
            case 1: {
                return "Huge Spruce Tree";
            }
            case 2: {
                return "Huge Birch Tree";
            }
            case 3: {
                return "Huge Jungle Tree";
            }
            case 4: {
                return "Huge Acacia Tree";
            }
            case 5: {
                return "Huge Dark Oak Tree";
            }
            case 6: {
                return "Huge Glass Tree";
            }
        }
        return "Error";
    }

    public void selectTreeIndex(int index) {
        this.selected = index;
        if (index >= 0 && index <= 6) {
            this.selectedTree = this.trees[this.selected];
            this.done.field_146124_l = true;
        } else {
            this.selectedTree = -1;
            this.done.field_146124_l = false;
        }
    }

    public boolean schematicIndexSelected(int var1) {
        return var1 == this.selected;
    }
}

