/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.gui.instant;

import com.slymask3.instantblocks.InstantBlocks;
import com.slymask3.instantblocks.block.BlockInstant;
import com.slymask3.instantblocks.gui.GuiInstant;
import com.slymask3.instantblocks.handler.Config;
import com.slymask3.instantblocks.network.PacketSkydive;
import com.slymask3.instantblocks.tileentity.TileEntitySkydive;
import com.slymask3.instantblocks.util.BuildHelper;
import com.slymask3.instantblocks.util.Colors;
import cpw.mods.fml.client.config.GuiButtonExt;
import cpw.mods.fml.client.config.GuiCheckBox;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class GuiSkydive
extends GuiInstant {
    protected final TileEntitySkydive tileEntity;
    private GuiButtonExt random;
    private GuiTextField[] color = new GuiTextField[11];
    private GuiCheckBox tp;
    private GuiTextField radius;
    private final int cutoff = 6;

    public GuiSkydive(EntityPlayer player, TileEntitySkydive entity, World world, int x, int y, int z) {
        super(player, world, x, y, z);
        this.tileEntity = entity;
    }

    @Override
    public void init() {
        int i;
        this.random = new GuiButtonExt(this.getID(), this.field_146294_l / 2 + 4, this.field_146295_m / 4 + 98 + 12, 150, 20, "Randomize");
        this.field_146292_n.add(this.random);
        this.tp = new GuiCheckBox(this.getID(), this.field_146294_l / 2 + 4, this.field_146295_m / 4 + 83 + 12, "Teleport to top", true);
        this.field_146292_n.add(this.tp);
        this.radius = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 4 - 100 - 12, this.field_146295_m / 4 + 100 + 12, 110, 16);
        this.radius.func_146180_a(String.valueOf(Config.SKYDIVE_RADIUS));
        for (i = 0; i < 6; ++i) {
            this.color[i] = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 4 - 100 + 6, 45 + 18 * i, 60, 14);
            this.color[i].func_146180_a(this.tileEntity.color[i]);
        }
        for (i = 6; i <= 10; ++i) {
            this.color[i] = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 + 4 + 50, 45 + 18 * (i - 6), 60, 14);
            this.color[i].func_146180_a(this.tileEntity.color[i]);
        }
    }

    @Override
    public void click(GuiButton btn) {
        if (btn.field_146127_k == this.random.field_146127_k) {
            this.setRandom();
        }
    }

    public void func_73876_c() {
        for (int i = 0; i < 11; ++i) {
            this.color[i].func_146178_a();
        }
        this.radius.func_146178_a();
    }

    @Override
    public void typed(char character, int key) {
        if ("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ ".indexOf(character) >= 0 || key == 14) {
            for (int i = 0; i < 11; ++i) {
                this.color[i].func_146201_a(character, key);
                this.tileEntity.setColorCode(i, this.color[i].func_146179_b());
                this.tileEntity.setColor(i, this.color[i].func_146179_b());
            }
        }
        if ("0123456789".indexOf(character) >= 0 || key == 14) {
            this.radius.func_146201_a(character, key);
        }
    }

    protected void func_73864_a(int x, int y, int click) {
        super.func_73864_a(x, y, click);
        for (int i = 0; i < 11; ++i) {
            this.color[i].func_146192_a(x, y, click);
        }
        this.radius.func_146192_a(x, y, click);
    }

    @Override
    public void draw(int par1, int par2, float par3) {
        int i;
        this.func_73732_a(this.field_146289_q, "Instant Skydive Block", this.field_146294_l / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Enter colors by name or hexadecimal value.", this.field_146294_l / 2 - 4 - 150, 33, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, "Radius:", this.field_146294_l / 2 - 4 - 150, this.field_146295_m / 4 + 104 + 12, 0xA0A0A0);
        for (i = 0; i < 6; ++i) {
            this.func_73731_b(this.field_146289_q, "Color " + (i + 1) + ":", this.field_146294_l / 2 - 4 - 150, 48 + 18 * i, this.tileEntity.colorCode[i]);
            this.color[i].func_146194_f();
        }
        for (i = 6; i <= 10; ++i) {
            this.func_73731_b(this.field_146289_q, "Color " + (i + 1) + ":", this.field_146294_l / 2 + 4, 48 + 18 * (i - 6), this.tileEntity.colorCode[i]);
            this.color[i].func_146194_f();
        }
        this.radius.func_146194_f();
    }

    @Override
    public void sendInfo() {
        int radius;
        try {
            radius = Integer.parseInt(this.radius.func_146179_b());
        }
        catch (NumberFormatException e) {
            radius = Config.SKYDIVE_RADIUS;
        }
        InstantBlocks.packetPipeline.sendToServer(new PacketSkydive(this.world, this.x, this.y, this.z, this.getColors(), radius, this.tp.isChecked()));
        BlockInstant block = (BlockInstant)BuildHelper.getBlock(this.world, this.x, this.y, this.z);
        block.afterBuild(this.world, this.x, this.y, this.z, this.player);
    }

    private int[] getColors() {
        int[] colors = new int[this.color.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = Colors.textToColor(this.color[i].func_146179_b()).getRGB();
        }
        return colors;
    }

    private void setRandom() {
        for (int i = 0; i <= 10; ++i) {
            this.color[i].func_146180_a(this.createRandomHex());
            this.tileEntity.setColorCode(i, this.color[i].func_146179_b());
            this.tileEntity.setColor(i, this.color[i].func_146179_b());
        }
    }

    private String createRandomHex() {
        Color color = Colors.generateRandomColor();
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

