/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.block.BlockInstant;
import com.slymask3.instantblocks.handler.Config;
import com.slymask3.instantblocks.init.ModBlocks;
import com.slymask3.instantblocks.reference.GuiID;
import com.slymask3.instantblocks.tileentity.TileEntitySkydive;
import com.slymask3.instantblocks.util.BuildHelper;
import com.slymask3.instantblocks.util.Colors;
import com.slymask3.instantblocks.util.Coords;
import com.slymask3.instantblocks.util.IBHelper;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockInstantSkydive
extends BlockInstant {
    public static IIcon bottom;
    public static IIcon top;
    public static IIcon side;

    public BlockInstantSkydive() {
        super("instantSkydive", Material.field_151580_n, Block.field_149775_l, 1.5f);
        this.func_149658_d("instantblocks:harvest_side_0");
        this.setGuiID(GuiID.SKYDIVE);
        this.setCreateMessage("Instant \u00a7cR\u00a76a\u00a7ei\u00a7an\u00a72b\u00a73o\u00a7bw \u00a7aSkydive created.");
    }

    @Override
    public void func_149651_a(IIconRegister ir) {
        bottom = ir.func_94245_a("instantblocks:skydive_bottom");
        top = ir.func_94245_a("instantblocks:skydive_top");
        side = ir.func_94245_a("instantblocks:skydive_side");
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return bottom;
        }
        if (side == 1) {
            return top;
        }
        if (side >= 2 && side <= 5) {
            return BlockInstantSkydive.side;
        }
        return this.field_149761_L;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack is) {
        int meta = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        world.func_72921_c(x, y, z, meta, 2);
    }

    public void build(World world, int x, int y, int z, EntityPlayer player, int[] selectedColors, int radius, boolean tp) {
        int i;
        int meta = world.func_72805_g(x, y, z);
        BuildHelper.setBlock(world, x, y, z, Blocks.field_150350_a);
        ArrayList<Coords> coordsList = new ArrayList<Coords>();
        ArrayList<Coords> coordsAirList = new ArrayList<Coords>();
        for (int row = 0; row <= 2 * radius; ++row) {
            for (int col = 0; col <= 2 * radius; ++col) {
                double distance = Math.sqrt((row - radius) * (row - radius) + (col - radius) * (col - radius));
                if (distance > (double)radius - 0.4 && distance < (double)radius + 0.5) {
                    coordsList.add(new Coords(x + row - radius, 0, z + col - radius));
                    continue;
                }
                if (!(distance < (double)radius - 0.3)) continue;
                coordsAirList.add(new Coords(x + row - radius, 0, z + col - radius));
            }
        }
        int index = 0;
        Color[] colors = new Color[selectedColors.length * 10];
        for (i = 0; i < selectedColors.length; ++i) {
            Color base;
            Color after = i + 1 < selectedColors.length ? new Color(selectedColors[i + 1]) : new Color(selectedColors[0]);
            colors[index] = base = new Color(selectedColors[i]);
            colors[++index] = Colors.getColorBetween(base, after, 90, 10);
            colors[++index] = Colors.getColorBetween(base, after, 80, 20);
            colors[++index] = Colors.getColorBetween(base, after, 70, 30);
            colors[++index] = Colors.getColorBetween(base, after, 60, 40);
            colors[++index] = Colors.getColorBetween(base, after, 50, 50);
            colors[++index] = Colors.getColorBetween(base, after, 40, 60);
            colors[++index] = Colors.getColorBetween(base, after, 30, 70);
            colors[++index] = Colors.getColorBetween(base, after, 20, 80);
            colors[++index] = Colors.getColorBetween(base, after, 10, 90);
            ++index;
        }
        i = 0;
        int min = Config.SKYDIVE_MIN;
        int max = Config.SKYDIVE_MAX;
        int water = Config.SKYDIVE_WATER;
        for (int c = max; c >= min; --c) {
            for (Coords coords : coordsAirList) {
                if (c == min) {
                    BuildHelper.setColorBlock(world, coords.getX(), c, coords.getZ(), colors[i].getRGB());
                    continue;
                }
                if (c < min + water + 1) {
                    BuildHelper.setBlock(world, coords.getX(), c, coords.getZ(), Blocks.field_150355_j);
                    continue;
                }
                BuildHelper.setBlock(world, coords.getX(), c, coords.getZ(), Blocks.field_150350_a);
            }
            for (Coords coords : coordsList) {
                if (i >= colors.length) {
                    i = 0;
                }
                if (c == min + water + 1 && ((coords.getX() - radius == x || coords.getX() + radius == x) && coords.getZ() == z || (coords.getZ() - radius == z || coords.getZ() + radius == z) && coords.getX() == x)) {
                    BuildHelper.setBlock(world, coords.getX(), c, coords.getZ(), ModBlocks.skydiveTP);
                    continue;
                }
                BuildHelper.setColorBlock(world, coords.getX(), c, coords.getZ(), colors[i].getRGB());
            }
            ++i;
        }
        if (meta == 0) {
            IBHelper.teleport(world, player, x, max + 1, z + radius, tp);
        } else if (meta == 1) {
            IBHelper.teleport(world, player, x - radius, max + 1, z, tp);
        } else if (meta == 2) {
            IBHelper.teleport(world, player, x, max + 1, z - radius, tp);
        } else if (meta == 3) {
            IBHelper.teleport(world, player, x + radius, max + 1, z, tp);
        }
    }

    @Override
    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntitySkydive();
    }
}

