/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.block.BlockInstant;
import com.slymask3.instantblocks.handler.Config;
import com.slymask3.instantblocks.init.ModBlocks;
import com.slymask3.instantblocks.util.BuildHelper;
import com.slymask3.instantblocks.util.IBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInstantLight
extends BlockInstant {
    public static IIcon side;
    public static IIcon top;

    public BlockInstantLight() {
        super("instantLight", Material.field_151575_d, Block.field_149766_f, 0.5f);
        this.setCreateMessage("Lit up this area.");
        this.func_149658_d("instantblocks:light_side");
        this.func_149676_a(0.375f, 0.0f, 0.375f, 0.625f, 0.9f, 0.625f);
        this.func_149715_a(1.0f);
    }

    @Override
    public void func_149651_a(IIconRegister ir) {
        side = ir.func_94245_a("instantblocks:light_side");
        top = ir.func_94245_a("instantblocks:light_top");
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (side == 1) {
            return top;
        }
        return BlockInstantLight.side;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        double d0 = (float)x + 0.5f;
        double d1 = (float)y + 0.5f;
        double d2 = (float)z + 0.5f;
        world.func_72869_a("smoke", d0 - 0.1, d1, d2, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", d0 - 0.1, d1, d2, 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", d0 + 0.1, d1, d2, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", d0 + 0.1, d1, d2, 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", d0, d1, d2, 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", d0, d1, d2 - 0.1, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", d0, d1, d2 - 0.1, 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", d0, d1, d2 + 0.1, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", d0, d1, d2 + 0.1, 0.0, 0.0, 0.0);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
    }

    @Override
    public void build(World world, int x, int y, int z, EntityPlayer player) {
        this.lightUp(world, x, y, z, Config.RADIUS_LIGHT, player);
    }

    public void lightUp(World world, int X, int Y, int Z, int radius, EntityPlayer player) {
        BuildHelper.setBlock(world, X, Y, Z, Blocks.field_150350_a);
        int amount = 0;
        int x = X - radius;
        int y = Y + radius;
        int z = Z - radius;
        int bx = x;
        int bz = z;
        for (int i = 0; i < radius * 2 + 1; ++i) {
            for (int j = 0; j < radius * 2 + 1; ++j) {
                for (int k = 0; k < radius * 2 + 1; ++k) {
                    Block block = BuildHelper.getBlock(world, x, y, z);
                    Block block1 = BuildHelper.getBlock(world, x + 1, y, z);
                    Block block2 = BuildHelper.getBlock(world, x - 1, y, z);
                    Block block4 = BuildHelper.getBlock(world, x, y - 1, z);
                    Block block5 = BuildHelper.getBlock(world, x, y, z + 1);
                    Block block6 = BuildHelper.getBlock(world, x, y, z - 1);
                    if (world.func_72957_l(x, y, z) < 10 && block == Blocks.field_150350_a && (block1.func_149662_c() || block2.func_149662_c() || block4.func_149662_c() || block5.func_149662_c() || block6.func_149662_c())) {
                        BuildHelper.setBlock(world, x, y, z, Blocks.field_150478_aa);
                        ++amount;
                    }
                    ++x;
                }
                ++z;
                x = bx;
            }
            z = bz;
            x = bx;
            --y;
        }
        if (amount > 0) {
            IBHelper.msg(player, "Lit up the area with %i% torches.".replace("%i%", String.valueOf(amount)), "\u00a7a");
            IBHelper.keepBlocks(world, x, y, z, ModBlocks.ibLight);
            IBHelper.xp(world, player, Config.XP_AMOUNT);
            IBHelper.sound(world, Config.SOUND, x, y, z);
            IBHelper.effectFull(world, Config.PARTICLE, x, y, z);
        } else {
            BuildHelper.setBlock(world, X, Y, Z, ModBlocks.ibLight);
            IBHelper.msg(player, "There are no dark areas to light up in a radius of %i% blocks.".replace("%i%", String.valueOf(Config.RADIUS_LIGHT)), "\u00a7c");
        }
    }
}

