/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block;

import com.slymask3.instantblocks.block.BlockInstant;
import com.slymask3.instantblocks.handler.Config;
import com.slymask3.instantblocks.init.ModBlocks;
import com.slymask3.instantblocks.util.BuildHelper;
import com.slymask3.instantblocks.util.Coords;
import com.slymask3.instantblocks.util.IBHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class BlockInstantLiquid
extends BlockInstant {
    public ArrayList<Coords> coordsList = new ArrayList();
    public Block blockCheck;
    public Block blockReplace;
    public String create;
    public String create1;
    public boolean isSuction = false;
    public String particle = null;

    public BlockInstantLiquid(String name, Material material, Block.SoundType soundType, float hardness, Block blockCheck, Block blockReplace) {
        super(name, material, soundType, hardness);
        this.blockCheck = blockCheck;
        this.blockReplace = blockReplace;
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (this.particle != null && random.nextInt(10) == 0) {
            for (int i = 0; i < 8; ++i) {
                world.func_72869_a(this.particle, (double)x + Math.random(), (double)y + 1.2, (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (this.isSuction) {
            return super.func_149668_a(world, x, y, z);
        }
        float f = 0.0625f;
        return AxisAlignedBB.func_72330_a((double)((float)x + f), (double)y, (double)((float)z + f), (double)((float)(x + 1) - f), (double)((float)(y + 1) - f), (double)((float)(z + 1) - f));
    }

    public boolean func_149686_d() {
        return this.isSuction;
    }

    public boolean func_149662_c() {
        return this.isSuction;
    }

    public int func_149701_w() {
        return this.field_149764_J == Material.field_151586_h ? 1 : 0;
    }

    private int getMax() {
        return this.isSuction ? Config.MAX_FILL : Config.MAX_LIQUID;
    }

    private Block getMainReplaceBlock() {
        if (this.isSuction) {
            return this.blockCheck == Blocks.field_150355_j ? ModBlocks.ibWater : ModBlocks.ibLava;
        }
        return this.blockReplace;
    }

    @Override
    public boolean canActivate(World world, int x, int y, int z, EntityPlayer player) {
        if (this.isSuction && Config.SHOW_EFFECTS) {
            world.func_72869_a("cloud", (double)x + 0.5, (double)y + 1.2, (double)z + 0.5, 0.0, 0.0, 0.0);
            world.func_72869_a("cloud", (double)x + 1.2, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
            world.func_72869_a("cloud", (double)x + 0.5, (double)y + 0.5, (double)z + 1.2, 0.0, 0.0, 0.0);
            world.func_72869_a("cloud", (double)x + 0.5, (double)y - 0.2, (double)z + 0.5, 0.0, 0.0, 0.0);
            world.func_72869_a("cloud", (double)x - 0.2, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
            world.func_72869_a("cloud", (double)x + 0.5, (double)y + 0.5, (double)z - 0.2, 0.0, 0.0, 0.0);
        }
        this.checkForBlock(world, x, y, z);
        if (this.isSuction && this.coordsList.isEmpty()) {
            IBHelper.msg(player, "No liquids found.", "\u00a7c");
            return false;
        }
        if (this.coordsList.size() >= this.getMax()) {
            IBHelper.msg(player, this.errorMessage, "\u00a7c");
            this.coordsList = new ArrayList();
            return false;
        }
        return true;
    }

    @Override
    public void build(World world, int x, int y, int z, EntityPlayer player) {
        for (Coords coords : this.coordsList) {
            BuildHelper.setBlock(world, coords.getX(), coords.getY(), coords.getZ(), this.blockReplace);
        }
        BuildHelper.setBlock(world, x, y, z, this.getMainReplaceBlock());
        if (this.coordsList.size() > 0) {
            this.setCreateMessage(this.create.replace("%i%", String.valueOf(this.isSuction ? this.coordsList.size() : this.coordsList.size() + 1)).replace("%type%", this.blockCheck == Blocks.field_150355_j ? "water" : "lava"));
        } else {
            this.setCreateMessage(this.create1.replace("%type%", this.blockCheck == Blocks.field_150355_j ? "water" : "lava"));
        }
        this.coordsList = new ArrayList();
        if (this.isSuction) {
            this.blockCheck = null;
        }
    }

    private void checkForBlock(World world, int x, int y, int z) {
        this.check(world, x + 1, y, z);
        this.check(world, x - 1, y, z);
        this.check(world, x, y, z + 1);
        this.check(world, x, y, z - 1);
        if (!Config.SIMPLE_LIQUID || this.isSuction) {
            this.check(world, x, y - 1, z);
        }
        if (this.isSuction) {
            this.check(world, x, y + 1, z);
        }
    }

    private void check(World world, int x, int y, int z) {
        Block blockCurrent = BuildHelper.getBlock(world, x, y, z);
        if (this.isCorrectBlock(blockCurrent) && this.coordsList.size() < this.getMax() && this.addCoords(x, y, z)) {
            if (this.blockCheck == null) {
                this.blockCheck = blockCurrent == Blocks.field_150358_i ? Blocks.field_150355_j : (blockCurrent == Blocks.field_150356_k ? Blocks.field_150353_l : blockCurrent);
            }
            this.checkForBlock(world, x, y, z);
        }
    }

    private boolean isCorrectBlock(Block block) {
        if (this.blockCheck == null) {
            return block == Blocks.field_150355_j || block == Blocks.field_150353_l || block == Blocks.field_150358_i || block == Blocks.field_150356_k;
        }
        if (this.blockCheck == Blocks.field_150350_a) {
            return block == this.blockCheck || block instanceof BlockBush || block == Blocks.field_150358_i || block == Blocks.field_150356_k;
        }
        if (this.blockCheck == Blocks.field_150355_j) {
            return block == this.blockCheck || block == Blocks.field_150358_i;
        }
        if (this.blockCheck == Blocks.field_150353_l) {
            return block == this.blockCheck || block == Blocks.field_150356_k;
        }
        return block == this.blockCheck;
    }

    private boolean addCoords(int x, int y, int z) {
        Coords coords = new Coords(x, y, z);
        if (!this.coordsList.contains(coords)) {
            this.coordsList.add(coords);
            return true;
        }
        return false;
    }
}

