/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.util.StackUtil;
import ic2ca.common.ArmorAssemblerRecipes;
import ic2ca.common.IC2CA;
import ic2ca.common.IItemUpgrade;
import ic2ca.common.IItemUpgradeable;
import ic2ca.common.Ic2caItems;
import ic2ca.common.container.ContainerArmorAssembler;
import ic2ca.common.gui.GuiArmorAssembler;
import ic2ca.common.item.ItemUpgrade;
import ic2ca.common.item.armor.ItemArmorTankUtility;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityArmorAssembler
extends TileEntityElectricMachine
implements IHasGui {
    public final InvSlotConsumableId inputSlot1 = new InvSlotConsumableId((TileEntityInventory)this, "input1", 0, 1, ArmorAssemblerRecipes.getItemList());
    public final InvSlotConsumableId inputSlot2 = new InvSlotConsumableId((TileEntityInventory)this, "input2", 1, 1, ArmorAssemblerRecipes.getItemList());
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 3, 1);
    public final InvSlotConsumableId updateSlot = new InvSlotConsumableId((TileEntityInventory)this, "upgrade", 4, 1, new Item[]{Ic2caItems.speedBooster.func_77973_b(), Ic2caItems.opUpgrade.func_77973_b()});
    private ItemStack slot0;
    private ItemStack slot1;
    public int progress = 0;
    public int maxProgress = 0;
    public int timeFactor = 14;
    public int energyConsume = 32;
    public static final int MAX_ENERGY = 50000;
    public static final int TIER = 2;
    public boolean recipeLoaded = false;
    public boolean loaded = false;

    public TileEntityArmorAssembler() {
        super(50000, 2, 2);
    }

    private boolean canCombine() {
        if (this.inputSlot1.get() == null || this.inputSlot2.get() == null) {
            return false;
        }
        RecipeOutput out = ArmorAssemblerRecipes.assembly().getAssemblyResult(this.inputSlot1.get(), this.inputSlot2.get());
        if (out == null) {
            return false;
        }
        ItemStack var1 = (ItemStack)out.items.get(0);
        if (var1 == null) {
            return false;
        }
        if (this.outputSlot.get() == null) {
            return true;
        }
        if (!this.outputSlot.get().func_77969_a(var1)) {
            return false;
        }
        int result = this.outputSlot.get().field_77994_a + var1.field_77994_a;
        return result <= this.func_70297_j_() && result <= var1.func_77976_d();
    }

    public void combineItem() {
        if (this.canCombine() && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ItemStack outputqqq = (ItemStack)ArmorAssemblerRecipes.assembly().getAssemblyResult((ItemStack)this.inputSlot1.get(), (ItemStack)this.inputSlot2.get()).items.get(0);
            ItemStack output = outputqqq.func_77946_l();
            IC2CA.instance.onCrafting(null, output, (IInventory)this);
            ItemStack in1 = this.inputSlot1.get();
            ItemStack in2 = this.inputSlot2.get();
            int charge = 0;
            NBTTagCompound nbtout = StackUtil.getOrCreateNbtData((ItemStack)output);
            NBTTagCompound nbtin1 = StackUtil.getOrCreateNbtData((ItemStack)in1);
            NBTTagCompound nbtin2 = StackUtil.getOrCreateNbtData((ItemStack)in2);
            charge += nbtin1.func_74762_e("charge");
            if ((charge += nbtin2.func_74762_e("charge")) > nbtout.func_74762_e("maxCharge")) {
                charge = nbtout.func_74762_e("maxCharge");
            }
            nbtout.func_74768_a("charge", charge);
            IC2CA.instance.updateElectricDamageBars(output);
            if (this.outputSlot.get() == null) {
                this.outputSlot.add(output);
            } else if (this.outputSlot.get().func_77969_a(output)) {
                this.outputSlot.get().field_77994_a += output.field_77994_a;
            }
            --this.inputSlot1.get().field_77994_a;
            if (this.inputSlot1.get().field_77994_a <= 0) {
                this.inputSlot1.clear();
            }
            --this.inputSlot2.get().field_77994_a;
            if (this.inputSlot2.get().field_77994_a <= 0) {
                this.inputSlot2.clear();
            }
            this.recipeLoaded = false;
        }
    }

    public String getEnergyString() {
        return "" + (int)(this.getChargeLevel() * 100.0f) + "%";
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiArmorAssembler(new ContainerArmorAssembler(player, this));
    }

    public ContainerBase getGuiContainer(EntityPlayer player) {
        return new ContainerArmorAssembler(player, this);
    }

    public String func_145825_b() {
        return "Armor Assembler";
    }

    public void getMaxProgress() {
        RecipeOutput out = ArmorAssemblerRecipes.assembly().getAssemblyResult(this.inputSlot1.get(), this.inputSlot2.get());
        ItemStack result = null;
        if (out != null) {
            result = (ItemStack)out.items.get(0);
        }
        if (result != null) {
            boolean var1 = false;
            int upgradeSlot = -1;
            if (this.inputSlot1.get().func_77973_b() instanceof IItemUpgrade) {
                var1 = true;
                upgradeSlot = 1;
            } else if (this.inputSlot1.get().func_77969_a(Ic2Items.overclockerUpgrade)) {
                var1 = true;
                upgradeSlot = 1;
            } else if (this.inputSlot1.get().func_77969_a(Ic2Items.energyStorageUpgrade)) {
                var1 = true;
                upgradeSlot = 1;
            } else if (this.inputSlot1.get().func_77969_a(Ic2Items.transformerUpgrade)) {
                var1 = true;
                upgradeSlot = 1;
            }
            if (this.inputSlot2.get().func_77973_b() instanceof IItemUpgrade) {
                var1 = true;
                upgradeSlot = 2;
            } else if (this.inputSlot2.get().func_77969_a(Ic2Items.overclockerUpgrade)) {
                var1 = true;
                upgradeSlot = 2;
            } else if (this.inputSlot2.get().func_77969_a(Ic2Items.energyStorageUpgrade)) {
                var1 = true;
                upgradeSlot = 2;
            } else if (this.inputSlot2.get().func_77969_a(Ic2Items.transformerUpgrade)) {
                var1 = true;
                upgradeSlot = 2;
            }
            if (var1) {
                if (result.func_77973_b() instanceof IItemUpgradeable) {
                    ItemUpgrade upg;
                    IItemUpgradeable item = (IItemUpgradeable)result.func_77973_b();
                    int modifier = 1;
                    if (upgradeSlot == 1 && this.inputSlot1.get().func_77973_b() instanceof ItemUpgrade) {
                        upg = (ItemUpgrade)this.inputSlot1.get().func_77973_b();
                        modifier = upg.getStackModifier(this.inputSlot1.get().func_77973_b());
                    }
                    if (upgradeSlot == 2 && this.inputSlot2.get().func_77973_b() instanceof ItemUpgrade) {
                        upg = (ItemUpgrade)this.inputSlot2.get().func_77973_b();
                        modifier = upg.getStackModifier(this.inputSlot2.get().func_77973_b());
                    }
                    int tier = item.getItemTier();
                    int mins = tier * 5;
                    int secs = mins * 60;
                    int ticks = secs * 20;
                    int eu = ticks * this.timeFactor;
                    int num = 0;
                    if (upgradeSlot == 1) {
                        num = this.inputSlot1.get().field_77994_a * modifier;
                    }
                    if (upgradeSlot == 2) {
                        num = this.inputSlot1.get().field_77994_a * modifier;
                    }
                    double min = (double)num * 1.875;
                    double sec = min * 60.0;
                    double tick = sec * 20.0;
                    int eu2 = (int)tick * this.timeFactor;
                    this.maxProgress = eu + eu2;
                } else if (result.func_77973_b() instanceof ItemArmorTankUtility) {
                    this.maxProgress = 18000 * this.timeFactor;
                }
            } else {
                int eu;
                IItemUpgradeable item = (IItemUpgradeable)result.func_77973_b();
                int tier = item.getItemTier();
                int mins = tier * 10;
                int secs = mins * 60;
                int ticks = secs * 20;
                this.maxProgress = eu = ticks * this.timeFactor;
            }
            if (this.updateSlot.get() != null && this.updateSlot.get().func_77969_a(Ic2caItems.speedBooster)) {
                this.maxProgress /= this.updateSlot.get().field_77994_a + 1;
            }
        } else {
            this.maxProgress = 0;
        }
    }

    public int getProgressScaled() {
        this.getMaxProgress();
        if (this.maxProgress == 0) {
            return 0;
        }
        return this.progress * 24 / this.maxProgress;
    }

    public String getProgressString() {
        int i = this.maxProgress / 100;
        if (i <= 0) {
            return "0%";
        }
        return "" + this.progress / i + "%";
    }

    public String getTimeString() {
        int hours;
        int seconds;
        if (this.maxProgress <= 0) {
            return String.format(StatCollector.func_74838_a((String)"info.remaining"), "0:00:00");
        }
        int mtime = this.maxProgress / 280;
        int time = this.progress / 280;
        int timeleft = mtime - time;
        int minutes = timeleft / 60;
        String s = (seconds = timeleft - ((minutes -= (hours = minutes / 60) * 60) * 60 + hours * 3600)) < 10 ? ":0" : ":";
        String s2 = minutes < 10 ? ":0" : ":";
        return String.format(StatCollector.func_74838_a((String)"info.remaining"), "" + hours + s2 + minutes + s + seconds);
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    public boolean isCombining() {
        return this.progress > 0;
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.slot0 != this.inputSlot1.get() || this.slot1 != this.inputSlot2.get()) {
            this.progress = 0;
            this.maxProgress = 0;
            this.slot0 = this.inputSlot1.get();
            this.slot1 = this.inputSlot2.get();
            this.recipeLoaded = false;
        }
        if (this.canCombine()) {
            this.getMaxProgress();
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.progress = par1NBTTagCompound.func_74762_e("progress");
        this.recipeLoaded = par1NBTTagCompound.func_74767_n("recipeLoaded");
        this.maxProgress = par1NBTTagCompound.func_74762_e("maxProgress");
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean var1 = this.isCombining();
        boolean needsInvUpdate = false;
        if (!this.loaded) {
            this.slot0 = this.inputSlot1.get();
            this.slot1 = this.inputSlot2.get();
            this.getMaxProgress();
            this.loaded = true;
        }
        if (this.energy >= (double)this.energyConsume && this.isCombining()) {
            this.energy -= (double)this.energyConsume;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateSlot.get() != null && this.updateSlot.get().func_77969_a(Ic2caItems.opUpgrade) && this.canCombine()) {
                this.progress = 0;
                this.combineItem();
                needsInvUpdate = true;
            }
            if (this.energy > 0.0 && this.canCombine()) {
                if (!this.recipeLoaded) {
                    this.getMaxProgress();
                    this.recipeLoaded = true;
                }
                this.progress += this.timeFactor;
                if (this.progress >= this.maxProgress) {
                    this.progress = 0;
                    this.energy -= (double)this.energyConsume;
                    this.combineItem();
                    needsInvUpdate = true;
                }
            } else {
                this.progress = 0;
            }
            if (var1 != this.isCombining()) {
                needsInvUpdate = true;
            }
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("progress", this.progress);
        par1NBTTagCompound.func_74757_a("recipeLoaded", this.recipeLoaded);
        par1NBTTagCompound.func_74768_a("maxProgress", this.maxProgress);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction.ordinal() != this.getFacing();
    }
}

