/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import ic2ca.api.IArmorAssemblerRecipeManager;
import ic2ca.common.ArmorAssemblerRecipes;
import ic2ca.common.gui.GuiArmorAssembler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ArmorAssemblerRecipeHandler
extends TemplateRecipeHandler {
    int ticks;

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiArmorAssembler.class;
    }

    public String getGuiTexture() {
        return "ic2ca:textures/gui/GuiArmorAssembler2.png";
    }

    public String getRecipeId() {
        return "ic2ca.armorassembler";
    }

    public Map<IArmorAssemblerRecipeManager.Input, RecipeOutput> getRecipeList() {
        return ArmorAssemblerRecipes.assembly().getRecipes();
    }

    public String getRecipeName() {
        return "Armor Assembler";
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (Map.Entry<IArmorAssemblerRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            for (ItemStack output : entry.getValue().items) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                this.arecipes.add(new CachedArmorAssemblerRecipe(entry.getKey().i1, entry.getKey().i2, entry.getValue()));
                continue block0;
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<IArmorAssemblerRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new CachedArmorAssemblerRecipe(entry.getKey().i1, entry.getKey().i2, entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<IArmorAssemblerRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            if (!entry.getKey().i1.matches(ingredient) && !entry.getKey().i2.matches(ingredient)) continue;
            this.arecipes.add(new CachedArmorAssemblerRecipe(entry.getKey().i1, entry.getKey().i2, entry.getValue()));
        }
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)16, (int)140, (int)65);
    }

    public void drawExtras(int i) {
        float f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(74, 19, 176, 14, 25, 16, f, 0);
        f = this.ticks <= 20 ? (float)this.ticks / 20.0f : 1.0f;
        this.drawProgressBar(51, 20, 176, 0, 14, 14, f, 3);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public class CachedArmorAssemblerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack output;
        public List<PositionedStack> ingredients;

        public CachedArmorAssemblerRecipe(IRecipeInput i1, IRecipeInput i2, RecipeOutput output1) {
            super((TemplateRecipeHandler)ArmorAssemblerRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            ArrayList<ItemStack> list1 = new ArrayList<ItemStack>();
            ArrayList<ItemStack> list2 = new ArrayList<ItemStack>();
            for (ItemStack item : i1.getInputs()) {
                list1.add(StackUtil.copyWithSize((ItemStack)item, (int)i1.getAmount()));
            }
            for (ItemStack item : i2.getInputs()) {
                list2.add(StackUtil.copyWithSize((ItemStack)item, (int)i2.getAmount()));
            }
            this.ingredients.add(new PositionedStack(list1, 63, 1));
            this.ingredients.add(new PositionedStack(list2, 37, 1));
            this.output = new PositionedStack(output1.items.get(0), 117, 19);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(ArmorAssemblerRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

